<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteBookmarkRequest StructType
 * @subpackage Structs
 */
class DeleteBookmarkRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The pgCode
     * @var int
     */
    public $pgCode;
    /**
     * Constructor method for deleteBookmarkRequest
     * @uses DeleteBookmarkRequest::setPersonId()
     * @uses DeleteBookmarkRequest::setPgCode()
     * @param int $personId
     * @param int $pgCode
     */
    public function __construct($personId = null, $pgCode = null)
    {
        $this
            ->setPersonId($personId)
            ->setPgCode($pgCode);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\DeleteBookmarkRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get pgCode value
     * @return int|null
     */
    public function getPgCode()
    {
        return $this->pgCode;
    }
    /**
     * Set pgCode value
     * @param int $pgCode
     * @return \QCC\CampusM\CloudService\StructType\DeleteBookmarkRequest
     */
    public function setPgCode($pgCode = null)
    {
        // validation for constraint: int
        if (!is_null($pgCode) && !is_numeric($pgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pgCode)), __LINE__);
        }
        $this->pgCode = $pgCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\DeleteBookmarkRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
