<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerRolesList StructType
 * @subpackage Structs
 */
class CustomerRolesList extends AbstractStructBase
{
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $role;
    /**
     * Constructor method for customerRolesList
     * @uses CustomerRolesList::setRole()
     * @param string[] $role
     */
    public function __construct(array $role = array())
    {
        $this
            ->setRole($role);
    }
    /**
     * Get role value
     * @return string[]|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @throws \InvalidArgumentException
     * @param string[] $role
     * @return \QCC\CampusM\CloudService\StructType\CustomerRolesList
     */
    public function setRole(array $role = array())
    {
        foreach ($role as $customerRolesListRoleItem) {
            // validation for constraint: itemType
            if (!is_string($customerRolesListRoleItem)) {
                throw new \InvalidArgumentException(sprintf('The role property can only contain items of string, "%s" given', is_object($customerRolesListRoleItem) ? get_class($customerRolesListRoleItem) : gettype($customerRolesListRoleItem)), __LINE__);
            }
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Add item to role value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\CustomerRolesList
     */
    public function addToRole($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The role property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->role[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\CustomerRolesList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
