<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createStudentRequest StructType
 * @subpackage Structs
 */
class CreateStudentRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The personPassword
     * @var string
     */
    public $personPassword;
    /**
     * The students
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Students
     */
    public $students;
    /**
     * Constructor method for createStudentRequest
     * @uses CreateStudentRequest::setPersonId()
     * @uses CreateStudentRequest::setPersonPassword()
     * @uses CreateStudentRequest::setStudents()
     * @param int $personId
     * @param string $personPassword
     * @param \QCC\CampusM\CloudService\StructType\Students $students
     */
    public function __construct($personId = null, $personPassword = null, \QCC\CampusM\CloudService\StructType\Students $students = null)
    {
        $this
            ->setPersonId($personId)
            ->setPersonPassword($personPassword)
            ->setStudents($students);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\CreateStudentRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get personPassword value
     * @return string|null
     */
    public function getPersonPassword()
    {
        return $this->personPassword;
    }
    /**
     * Set personPassword value
     * @param string $personPassword
     * @return \QCC\CampusM\CloudService\StructType\CreateStudentRequest
     */
    public function setPersonPassword($personPassword = null)
    {
        // validation for constraint: string
        if (!is_null($personPassword) && !is_string($personPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personPassword)), __LINE__);
        }
        $this->personPassword = $personPassword;
        return $this;
    }
    /**
     * Get students value
     * @return \QCC\CampusM\CloudService\StructType\Students|null
     */
    public function getStudents()
    {
        return $this->students;
    }
    /**
     * Set students value
     * @param \QCC\CampusM\CloudService\StructType\Students $students
     * @return \QCC\CampusM\CloudService\StructType\CreateStudentRequest
     */
    public function setStudents(\QCC\CampusM\CloudService\StructType\Students $students = null)
    {
        $this->students = $students;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\CreateStudentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
