<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for campusmUser StructType
 * @subpackage Structs
 */
class CampusmUser extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surname;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The dateRegistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateRegistered;
    /**
     * The dateLastUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateLastUsed;
    /**
     * The profiles
     * @var \QCC\CampusM\CloudService\StructType\AppUserProfiles
     */
    public $profiles;
    /**
     * The alertSubscriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\AppUserAlertSubscriptions
     */
    public $alertSubscriptions;
    /**
     * Constructor method for campusmUser
     * @uses CampusmUser::setPersonId()
     * @uses CampusmUser::setFirstName()
     * @uses CampusmUser::setSurname()
     * @uses CampusmUser::setEmail()
     * @uses CampusmUser::setDateRegistered()
     * @uses CampusmUser::setDateLastUsed()
     * @uses CampusmUser::setProfiles()
     * @uses CampusmUser::setAlertSubscriptions()
     * @param int $personId
     * @param string $firstName
     * @param string $surname
     * @param string $email
     * @param string $dateRegistered
     * @param string $dateLastUsed
     * @param \QCC\CampusM\CloudService\StructType\AppUserProfiles $profiles
     * @param \QCC\CampusM\CloudService\StructType\AppUserAlertSubscriptions $alertSubscriptions
     */
    public function __construct($personId = null, $firstName = null, $surname = null, $email = null, $dateRegistered = null, $dateLastUsed = null, \QCC\CampusM\CloudService\StructType\AppUserProfiles $profiles = null, \QCC\CampusM\CloudService\StructType\AppUserAlertSubscriptions $alertSubscriptions = null)
    {
        $this
            ->setPersonId($personId)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setEmail($email)
            ->setDateRegistered($dateRegistered)
            ->setDateLastUsed($dateLastUsed)
            ->setProfiles($profiles)
            ->setAlertSubscriptions($alertSubscriptions);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get dateRegistered value
     * @return string|null
     */
    public function getDateRegistered()
    {
        return $this->dateRegistered;
    }
    /**
     * Set dateRegistered value
     * @param string $dateRegistered
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setDateRegistered($dateRegistered = null)
    {
        // validation for constraint: string
        if (!is_null($dateRegistered) && !is_string($dateRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistered)), __LINE__);
        }
        $this->dateRegistered = $dateRegistered;
        return $this;
    }
    /**
     * Get dateLastUsed value
     * @return string|null
     */
    public function getDateLastUsed()
    {
        return $this->dateLastUsed;
    }
    /**
     * Set dateLastUsed value
     * @param string $dateLastUsed
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setDateLastUsed($dateLastUsed = null)
    {
        // validation for constraint: string
        if (!is_null($dateLastUsed) && !is_string($dateLastUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateLastUsed)), __LINE__);
        }
        $this->dateLastUsed = $dateLastUsed;
        return $this;
    }
    /**
     * Get profiles value
     * @return \QCC\CampusM\CloudService\StructType\AppUserProfiles|null
     */
    public function getProfiles()
    {
        return $this->profiles;
    }
    /**
     * Set profiles value
     * @param \QCC\CampusM\CloudService\StructType\AppUserProfiles $profiles
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setProfiles(\QCC\CampusM\CloudService\StructType\AppUserProfiles $profiles = null)
    {
        $this->profiles = $profiles;
        return $this;
    }
    /**
     * Get alertSubscriptions value
     * @return \QCC\CampusM\CloudService\StructType\AppUserAlertSubscriptions|null
     */
    public function getAlertSubscriptions()
    {
        return $this->alertSubscriptions;
    }
    /**
     * Set alertSubscriptions value
     * @param \QCC\CampusM\CloudService\StructType\AppUserAlertSubscriptions $alertSubscriptions
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public function setAlertSubscriptions(\QCC\CampusM\CloudService\StructType\AppUserAlertSubscriptions $alertSubscriptions = null)
    {
        $this->alertSubscriptions = $alertSubscriptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\CampusmUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
