<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authAccess StructType
 * @subpackage Structs
 */
class AuthAccess extends AbstractStructBase
{
    /**
     * The ldapServiceAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapServiceAccess;
    /**
     * The accessType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessType;
    /**
     * The authEndpoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authEndpoint;
    /**
     * The authEndpointProxyAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $authEndpointProxyAddress;
    /**
     * The authEndpointProxyUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $authEndpointProxyUrl;
    /**
     * The authEndpointProxyKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $authEndpointProxyKey;
    /**
     * The authUsername
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authUsername;
    /**
     * The authPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authPassword;
    /**
     * The authPrompt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authPrompt;
    /**
     * The authPromptLabel1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authPromptLabel1;
    /**
     * The authPromptLabel2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authPromptLabel2;
    /**
     * The authFailureMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authFailureMessage;
    /**
     * The ssoDirectory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssoDirectory;
    /**
     * The ssoAuthEndpoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssoAuthEndpoint;
    /**
     * The ssoHost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssoHost;
    /**
     * The ssoLogoutUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssoLogoutUrl;
    /**
     * The oAuthAuthorizeEndpoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthAuthorizeEndpoint;
    /**
     * The oAuthTokenEndpoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthTokenEndpoint;
    /**
     * The oAuthScope
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthScope;
    /**
     * The oAuthClientID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthClientID;
    /**
     * The oAuthCallbackURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthCallbackURL;
    /**
     * The oAuthCallbackType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthCallbackType;
    /**
     * Constructor method for authAccess
     * @uses AuthAccess::setLdapServiceAccess()
     * @uses AuthAccess::setAccessType()
     * @uses AuthAccess::setAuthEndpoint()
     * @uses AuthAccess::setAuthEndpointProxyAddress()
     * @uses AuthAccess::setAuthEndpointProxyUrl()
     * @uses AuthAccess::setAuthEndpointProxyKey()
     * @uses AuthAccess::setAuthUsername()
     * @uses AuthAccess::setAuthPassword()
     * @uses AuthAccess::setAuthPrompt()
     * @uses AuthAccess::setAuthPromptLabel1()
     * @uses AuthAccess::setAuthPromptLabel2()
     * @uses AuthAccess::setAuthFailureMessage()
     * @uses AuthAccess::setSsoDirectory()
     * @uses AuthAccess::setSsoAuthEndpoint()
     * @uses AuthAccess::setSsoHost()
     * @uses AuthAccess::setSsoLogoutUrl()
     * @uses AuthAccess::setOAuthAuthorizeEndpoint()
     * @uses AuthAccess::setOAuthTokenEndpoint()
     * @uses AuthAccess::setOAuthScope()
     * @uses AuthAccess::setOAuthClientID()
     * @uses AuthAccess::setOAuthCallbackURL()
     * @uses AuthAccess::setOAuthCallbackType()
     * @param string $ldapServiceAccess
     * @param string $accessType
     * @param string $authEndpoint
     * @param string $authEndpointProxyAddress
     * @param string $authEndpointProxyUrl
     * @param string $authEndpointProxyKey
     * @param string $authUsername
     * @param string $authPassword
     * @param string $authPrompt
     * @param string $authPromptLabel1
     * @param string $authPromptLabel2
     * @param string $authFailureMessage
     * @param string $ssoDirectory
     * @param string $ssoAuthEndpoint
     * @param string $ssoHost
     * @param string $ssoLogoutUrl
     * @param string $oAuthAuthorizeEndpoint
     * @param string $oAuthTokenEndpoint
     * @param string $oAuthScope
     * @param string $oAuthClientID
     * @param string $oAuthCallbackURL
     * @param string $oAuthCallbackType
     */
    public function __construct($ldapServiceAccess = null, $accessType = null, $authEndpoint = null, $authEndpointProxyAddress = null, $authEndpointProxyUrl = null, $authEndpointProxyKey = null, $authUsername = null, $authPassword = null, $authPrompt = null, $authPromptLabel1 = null, $authPromptLabel2 = null, $authFailureMessage = null, $ssoDirectory = null, $ssoAuthEndpoint = null, $ssoHost = null, $ssoLogoutUrl = null, $oAuthAuthorizeEndpoint = null, $oAuthTokenEndpoint = null, $oAuthScope = null, $oAuthClientID = null, $oAuthCallbackURL = null, $oAuthCallbackType = null)
    {
        $this
            ->setLdapServiceAccess($ldapServiceAccess)
            ->setAccessType($accessType)
            ->setAuthEndpoint($authEndpoint)
            ->setAuthEndpointProxyAddress($authEndpointProxyAddress)
            ->setAuthEndpointProxyUrl($authEndpointProxyUrl)
            ->setAuthEndpointProxyKey($authEndpointProxyKey)
            ->setAuthUsername($authUsername)
            ->setAuthPassword($authPassword)
            ->setAuthPrompt($authPrompt)
            ->setAuthPromptLabel1($authPromptLabel1)
            ->setAuthPromptLabel2($authPromptLabel2)
            ->setAuthFailureMessage($authFailureMessage)
            ->setSsoDirectory($ssoDirectory)
            ->setSsoAuthEndpoint($ssoAuthEndpoint)
            ->setSsoHost($ssoHost)
            ->setSsoLogoutUrl($ssoLogoutUrl)
            ->setOAuthAuthorizeEndpoint($oAuthAuthorizeEndpoint)
            ->setOAuthTokenEndpoint($oAuthTokenEndpoint)
            ->setOAuthScope($oAuthScope)
            ->setOAuthClientID($oAuthClientID)
            ->setOAuthCallbackURL($oAuthCallbackURL)
            ->setOAuthCallbackType($oAuthCallbackType);
    }
    /**
     * Get ldapServiceAccess value
     * @return string|null
     */
    public function getLdapServiceAccess()
    {
        return $this->ldapServiceAccess;
    }
    /**
     * Set ldapServiceAccess value
     * @param string $ldapServiceAccess
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setLdapServiceAccess($ldapServiceAccess = null)
    {
        // validation for constraint: string
        if (!is_null($ldapServiceAccess) && !is_string($ldapServiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapServiceAccess)), __LINE__);
        }
        $this->ldapServiceAccess = $ldapServiceAccess;
        return $this;
    }
    /**
     * Get accessType value
     * @return string|null
     */
    public function getAccessType()
    {
        return $this->accessType;
    }
    /**
     * Set accessType value
     * @param string $accessType
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAccessType($accessType = null)
    {
        // validation for constraint: string
        if (!is_null($accessType) && !is_string($accessType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessType)), __LINE__);
        }
        $this->accessType = $accessType;
        return $this;
    }
    /**
     * Get authEndpoint value
     * @return string|null
     */
    public function getAuthEndpoint()
    {
        return $this->authEndpoint;
    }
    /**
     * Set authEndpoint value
     * @param string $authEndpoint
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthEndpoint($authEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($authEndpoint) && !is_string($authEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authEndpoint)), __LINE__);
        }
        $this->authEndpoint = $authEndpoint;
        return $this;
    }
    /**
     * Get authEndpointProxyAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthEndpointProxyAddress()
    {
        return isset($this->authEndpointProxyAddress) ? $this->authEndpointProxyAddress : null;
    }
    /**
     * Set authEndpointProxyAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authEndpointProxyAddress
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthEndpointProxyAddress($authEndpointProxyAddress = null)
    {
        // validation for constraint: string
        if (!is_null($authEndpointProxyAddress) && !is_string($authEndpointProxyAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authEndpointProxyAddress)), __LINE__);
        }
        if (is_null($authEndpointProxyAddress) || (is_array($authEndpointProxyAddress) && empty($authEndpointProxyAddress))) {
            unset($this->authEndpointProxyAddress);
        } else {
            $this->authEndpointProxyAddress = $authEndpointProxyAddress;
        }
        return $this;
    }
    /**
     * Get authEndpointProxyUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthEndpointProxyUrl()
    {
        return isset($this->authEndpointProxyUrl) ? $this->authEndpointProxyUrl : null;
    }
    /**
     * Set authEndpointProxyUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authEndpointProxyUrl
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthEndpointProxyUrl($authEndpointProxyUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authEndpointProxyUrl) && !is_string($authEndpointProxyUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authEndpointProxyUrl)), __LINE__);
        }
        if (is_null($authEndpointProxyUrl) || (is_array($authEndpointProxyUrl) && empty($authEndpointProxyUrl))) {
            unset($this->authEndpointProxyUrl);
        } else {
            $this->authEndpointProxyUrl = $authEndpointProxyUrl;
        }
        return $this;
    }
    /**
     * Get authEndpointProxyKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthEndpointProxyKey()
    {
        return isset($this->authEndpointProxyKey) ? $this->authEndpointProxyKey : null;
    }
    /**
     * Set authEndpointProxyKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authEndpointProxyKey
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthEndpointProxyKey($authEndpointProxyKey = null)
    {
        // validation for constraint: string
        if (!is_null($authEndpointProxyKey) && !is_string($authEndpointProxyKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authEndpointProxyKey)), __LINE__);
        }
        if (is_null($authEndpointProxyKey) || (is_array($authEndpointProxyKey) && empty($authEndpointProxyKey))) {
            unset($this->authEndpointProxyKey);
        } else {
            $this->authEndpointProxyKey = $authEndpointProxyKey;
        }
        return $this;
    }
    /**
     * Get authUsername value
     * @return string|null
     */
    public function getAuthUsername()
    {
        return $this->authUsername;
    }
    /**
     * Set authUsername value
     * @param string $authUsername
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthUsername($authUsername = null)
    {
        // validation for constraint: string
        if (!is_null($authUsername) && !is_string($authUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authUsername)), __LINE__);
        }
        $this->authUsername = $authUsername;
        return $this;
    }
    /**
     * Get authPassword value
     * @return string|null
     */
    public function getAuthPassword()
    {
        return $this->authPassword;
    }
    /**
     * Set authPassword value
     * @param string $authPassword
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthPassword($authPassword = null)
    {
        // validation for constraint: string
        if (!is_null($authPassword) && !is_string($authPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPassword)), __LINE__);
        }
        $this->authPassword = $authPassword;
        return $this;
    }
    /**
     * Get authPrompt value
     * @return string|null
     */
    public function getAuthPrompt()
    {
        return $this->authPrompt;
    }
    /**
     * Set authPrompt value
     * @param string $authPrompt
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthPrompt($authPrompt = null)
    {
        // validation for constraint: string
        if (!is_null($authPrompt) && !is_string($authPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPrompt)), __LINE__);
        }
        $this->authPrompt = $authPrompt;
        return $this;
    }
    /**
     * Get authPromptLabel1 value
     * @return string|null
     */
    public function getAuthPromptLabel1()
    {
        return $this->authPromptLabel1;
    }
    /**
     * Set authPromptLabel1 value
     * @param string $authPromptLabel1
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthPromptLabel1($authPromptLabel1 = null)
    {
        // validation for constraint: string
        if (!is_null($authPromptLabel1) && !is_string($authPromptLabel1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPromptLabel1)), __LINE__);
        }
        $this->authPromptLabel1 = $authPromptLabel1;
        return $this;
    }
    /**
     * Get authPromptLabel2 value
     * @return string|null
     */
    public function getAuthPromptLabel2()
    {
        return $this->authPromptLabel2;
    }
    /**
     * Set authPromptLabel2 value
     * @param string $authPromptLabel2
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthPromptLabel2($authPromptLabel2 = null)
    {
        // validation for constraint: string
        if (!is_null($authPromptLabel2) && !is_string($authPromptLabel2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPromptLabel2)), __LINE__);
        }
        $this->authPromptLabel2 = $authPromptLabel2;
        return $this;
    }
    /**
     * Get authFailureMessage value
     * @return string|null
     */
    public function getAuthFailureMessage()
    {
        return $this->authFailureMessage;
    }
    /**
     * Set authFailureMessage value
     * @param string $authFailureMessage
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setAuthFailureMessage($authFailureMessage = null)
    {
        // validation for constraint: string
        if (!is_null($authFailureMessage) && !is_string($authFailureMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authFailureMessage)), __LINE__);
        }
        $this->authFailureMessage = $authFailureMessage;
        return $this;
    }
    /**
     * Get ssoDirectory value
     * @return string|null
     */
    public function getSsoDirectory()
    {
        return $this->ssoDirectory;
    }
    /**
     * Set ssoDirectory value
     * @param string $ssoDirectory
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setSsoDirectory($ssoDirectory = null)
    {
        // validation for constraint: string
        if (!is_null($ssoDirectory) && !is_string($ssoDirectory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssoDirectory)), __LINE__);
        }
        $this->ssoDirectory = $ssoDirectory;
        return $this;
    }
    /**
     * Get ssoAuthEndpoint value
     * @return string|null
     */
    public function getSsoAuthEndpoint()
    {
        return $this->ssoAuthEndpoint;
    }
    /**
     * Set ssoAuthEndpoint value
     * @param string $ssoAuthEndpoint
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setSsoAuthEndpoint($ssoAuthEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($ssoAuthEndpoint) && !is_string($ssoAuthEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssoAuthEndpoint)), __LINE__);
        }
        $this->ssoAuthEndpoint = $ssoAuthEndpoint;
        return $this;
    }
    /**
     * Get ssoHost value
     * @return string|null
     */
    public function getSsoHost()
    {
        return $this->ssoHost;
    }
    /**
     * Set ssoHost value
     * @param string $ssoHost
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setSsoHost($ssoHost = null)
    {
        // validation for constraint: string
        if (!is_null($ssoHost) && !is_string($ssoHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssoHost)), __LINE__);
        }
        $this->ssoHost = $ssoHost;
        return $this;
    }
    /**
     * Get ssoLogoutUrl value
     * @return string|null
     */
    public function getSsoLogoutUrl()
    {
        return $this->ssoLogoutUrl;
    }
    /**
     * Set ssoLogoutUrl value
     * @param string $ssoLogoutUrl
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setSsoLogoutUrl($ssoLogoutUrl = null)
    {
        // validation for constraint: string
        if (!is_null($ssoLogoutUrl) && !is_string($ssoLogoutUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssoLogoutUrl)), __LINE__);
        }
        $this->ssoLogoutUrl = $ssoLogoutUrl;
        return $this;
    }
    /**
     * Get oAuthAuthorizeEndpoint value
     * @return string|null
     */
    public function getOAuthAuthorizeEndpoint()
    {
        return $this->oAuthAuthorizeEndpoint;
    }
    /**
     * Set oAuthAuthorizeEndpoint value
     * @param string $oAuthAuthorizeEndpoint
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setOAuthAuthorizeEndpoint($oAuthAuthorizeEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthAuthorizeEndpoint) && !is_string($oAuthAuthorizeEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthAuthorizeEndpoint)), __LINE__);
        }
        $this->oAuthAuthorizeEndpoint = $oAuthAuthorizeEndpoint;
        return $this;
    }
    /**
     * Get oAuthTokenEndpoint value
     * @return string|null
     */
    public function getOAuthTokenEndpoint()
    {
        return $this->oAuthTokenEndpoint;
    }
    /**
     * Set oAuthTokenEndpoint value
     * @param string $oAuthTokenEndpoint
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setOAuthTokenEndpoint($oAuthTokenEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthTokenEndpoint) && !is_string($oAuthTokenEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthTokenEndpoint)), __LINE__);
        }
        $this->oAuthTokenEndpoint = $oAuthTokenEndpoint;
        return $this;
    }
    /**
     * Get oAuthScope value
     * @return string|null
     */
    public function getOAuthScope()
    {
        return $this->oAuthScope;
    }
    /**
     * Set oAuthScope value
     * @param string $oAuthScope
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setOAuthScope($oAuthScope = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthScope) && !is_string($oAuthScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthScope)), __LINE__);
        }
        $this->oAuthScope = $oAuthScope;
        return $this;
    }
    /**
     * Get oAuthClientID value
     * @return string|null
     */
    public function getOAuthClientID()
    {
        return $this->oAuthClientID;
    }
    /**
     * Set oAuthClientID value
     * @param string $oAuthClientID
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setOAuthClientID($oAuthClientID = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthClientID) && !is_string($oAuthClientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthClientID)), __LINE__);
        }
        $this->oAuthClientID = $oAuthClientID;
        return $this;
    }
    /**
     * Get oAuthCallbackURL value
     * @return string|null
     */
    public function getOAuthCallbackURL()
    {
        return $this->oAuthCallbackURL;
    }
    /**
     * Set oAuthCallbackURL value
     * @param string $oAuthCallbackURL
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setOAuthCallbackURL($oAuthCallbackURL = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthCallbackURL) && !is_string($oAuthCallbackURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthCallbackURL)), __LINE__);
        }
        $this->oAuthCallbackURL = $oAuthCallbackURL;
        return $this;
    }
    /**
     * Get oAuthCallbackType value
     * @return string|null
     */
    public function getOAuthCallbackType()
    {
        return $this->oAuthCallbackType;
    }
    /**
     * Set oAuthCallbackType value
     * @param string $oAuthCallbackType
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public function setOAuthCallbackType($oAuthCallbackType = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthCallbackType) && !is_string($oAuthCallbackType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthCallbackType)), __LINE__);
        }
        $this->oAuthCallbackType = $oAuthCallbackType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
