<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for assetIdentifier StructType
 * @subpackage Structs
 */
class AssetIdentifier extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - default: ASSET
     * @var string
     */
    public $type;
    /**
     * The identifier
     * @var string
     */
    public $identifier;
    /**
     * The lastUpdated
     * @var string
     */
    public $lastUpdated;
    /**
     * Constructor method for assetIdentifier
     * @uses AssetIdentifier::setType()
     * @uses AssetIdentifier::setIdentifier()
     * @uses AssetIdentifier::setLastUpdated()
     * @param string $type
     * @param string $identifier
     * @param string $lastUpdated
     */
    public function __construct($type = 'ASSET', $identifier = null, $lastUpdated = null)
    {
        $this
            ->setType($type)
            ->setIdentifier($identifier)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \QCC\CampusM\CloudService\StructType\AssetIdentifier
     */
    public function setType($type = 'ASSET')
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param string $identifier
     * @return \QCC\CampusM\CloudService\StructType\AssetIdentifier
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifier)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get lastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->lastUpdated;
    }
    /**
     * Set lastUpdated value
     * @param string $lastUpdated
     * @return \QCC\CampusM\CloudService\StructType\AssetIdentifier
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->lastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AssetIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
