<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appUsersRequest StructType
 * @subpackage Structs
 */
class AppUsersRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgServicePassword
     * @var string
     */
    public $orgServicePassword;
    /**
     * The alertGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $alertGroupId;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $profileId;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailAddress;
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personId;
    /**
     * Constructor method for appUsersRequest
     * @uses AppUsersRequest::setOrgCode()
     * @uses AppUsersRequest::setOrgServicePassword()
     * @uses AppUsersRequest::setAlertGroupId()
     * @uses AppUsersRequest::setProfileId()
     * @uses AppUsersRequest::setEmailAddress()
     * @uses AppUsersRequest::setPersonId()
     * @param int $orgCode
     * @param string $orgServicePassword
     * @param int $alertGroupId
     * @param int $profileId
     * @param string $emailAddress
     * @param int $personId
     */
    public function __construct($orgCode = null, $orgServicePassword = null, $alertGroupId = null, $profileId = null, $emailAddress = null, $personId = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgServicePassword($orgServicePassword)
            ->setAlertGroupId($alertGroupId)
            ->setProfileId($profileId)
            ->setEmailAddress($emailAddress)
            ->setPersonId($personId);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\AppUsersRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgServicePassword value
     * @return string|null
     */
    public function getOrgServicePassword()
    {
        return $this->orgServicePassword;
    }
    /**
     * Set orgServicePassword value
     * @param string $orgServicePassword
     * @return \QCC\CampusM\CloudService\StructType\AppUsersRequest
     */
    public function setOrgServicePassword($orgServicePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgServicePassword) && !is_string($orgServicePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgServicePassword)), __LINE__);
        }
        $this->orgServicePassword = $orgServicePassword;
        return $this;
    }
    /**
     * Get alertGroupId value
     * @return int|null
     */
    public function getAlertGroupId()
    {
        return $this->alertGroupId;
    }
    /**
     * Set alertGroupId value
     * @param int $alertGroupId
     * @return \QCC\CampusM\CloudService\StructType\AppUsersRequest
     */
    public function setAlertGroupId($alertGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($alertGroupId) && !is_numeric($alertGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($alertGroupId)), __LINE__);
        }
        $this->alertGroupId = $alertGroupId;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\AppUsersRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\AppUsersRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\AppUsersRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AppUsersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
