<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appUserProfile StructType
 * @subpackage Structs
 */
class AppUserProfile extends AbstractStructBase
{
    /**
     * The profileId
     * @var int
     */
    public $profileId;
    /**
     * The profileName
     * @var string
     */
    public $profileName;
    /**
     * Constructor method for appUserProfile
     * @uses AppUserProfile::setProfileId()
     * @uses AppUserProfile::setProfileName()
     * @param int $profileId
     * @param string $profileName
     */
    public function __construct($profileId = null, $profileName = null)
    {
        $this
            ->setProfileId($profileId)
            ->setProfileName($profileName);
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\AppUserProfile
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get profileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * Set profileName value
     * @param string $profileName
     * @return \QCC\CampusM\CloudService\StructType\AppUserProfile
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileName)), __LINE__);
        }
        $this->profileName = $profileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AppUserProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
