<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appDirectoryLoginRequest StructType
 * @subpackage Structs
 */
class AppDirectoryLoginRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The profileGroupId
     * @var int
     */
    public $profileGroupId;
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * Constructor method for appDirectoryLoginRequest
     * @uses AppDirectoryLoginRequest::setOrgCode()
     * @uses AppDirectoryLoginRequest::setOrgMobilePassword()
     * @uses AppDirectoryLoginRequest::setProfileGroupId()
     * @uses AppDirectoryLoginRequest::setUsername()
     * @uses AppDirectoryLoginRequest::setPassword()
     * @param int $orgCode
     * @param string $orgMobilePassword
     * @param int $profileGroupId
     * @param string $username
     * @param string $password
     */
    public function __construct($orgCode = null, $orgMobilePassword = null, $profileGroupId = null, $username = null, $password = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setProfileGroupId($profileGroupId)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get profileGroupId value
     * @return int|null
     */
    public function getProfileGroupId()
    {
        return $this->profileGroupId;
    }
    /**
     * Set profileGroupId value
     * @param int $profileGroupId
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest
     */
    public function setProfileGroupId($profileGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($profileGroupId) && !is_numeric($profileGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileGroupId)), __LINE__);
        }
        $this->profileGroupId = $profileGroupId;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
