<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for alerts StructType
 * @subpackage Structs
 */
class Alerts extends AbstractStructBase
{
    /**
     * The alert
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Alert[]
     */
    public $alert;
    /**
     * Constructor method for alerts
     * @uses Alerts::setAlert()
     * @param \QCC\CampusM\CloudService\StructType\Alert[] $alert
     */
    public function __construct(array $alert = array())
    {
        $this
            ->setAlert($alert);
    }
    /**
     * Get alert value
     * @return \QCC\CampusM\CloudService\StructType\Alert[]|null
     */
    public function getAlert()
    {
        return $this->alert;
    }
    /**
     * Set alert value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Alert[] $alert
     * @return \QCC\CampusM\CloudService\StructType\Alerts
     */
    public function setAlert(array $alert = array())
    {
        foreach ($alert as $alertsAlertItem) {
            // validation for constraint: itemType
            if (!$alertsAlertItem instanceof \QCC\CampusM\CloudService\StructType\Alert) {
                throw new \InvalidArgumentException(sprintf('The alert property can only contain items of \QCC\CampusM\CloudService\StructType\Alert, "%s" given', is_object($alertsAlertItem) ? get_class($alertsAlertItem) : gettype($alertsAlertItem)), __LINE__);
            }
        }
        $this->alert = $alert;
        return $this;
    }
    /**
     * Add item to alert value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Alert $item
     * @return \QCC\CampusM\CloudService\StructType\Alerts
     */
    public function addToAlert(\QCC\CampusM\CloudService\StructType\Alert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Alert) {
            throw new \InvalidArgumentException(sprintf('The alert property can only contain items of \QCC\CampusM\CloudService\StructType\Alert, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->alert[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Alerts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
