<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateUserDetailService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateUserDetailService(\QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateUserDetailService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirectoryList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateDirectoryListRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\UpdateDirectoryListResponse|bool
     */
    public function updateDirectoryList(\QCC\CampusM\CloudService\StructType\UpdateDirectoryListRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDirectoryList($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMenu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateMenuRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateMenu(\QCC\CampusM\CloudService\StructType\UpdateMenuRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMenu($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMyLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateMyLocation(\QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMyLocation($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRssSubs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateRssSubsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateRssSubs(\QCC\CampusM\CloudService\StructType\UpdateRssSubsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateRssSubs($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAlertSubscriptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateAlertSubscriptionsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateAlertSubscriptions(\QCC\CampusM\CloudService\StructType\UpdateAlertSubscriptionsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateAlertSubscriptions($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDistanceSetting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateDistanceSetting(\QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateDistanceSetting($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFavourites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateFavouritesRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateFavourites(\QCC\CampusM\CloudService\StructType\UpdateFavouritesRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFavourites($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFriends
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateFriendsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateFriends(\QCC\CampusM\CloudService\StructType\UpdateFriendsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFriends($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePerson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdatePerson $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updatePerson(\QCC\CampusM\CloudService\StructType\UpdatePerson $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePerson($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePositionNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdatePositionNotes $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updatePositionNotes(\QCC\CampusM\CloudService\StructType\UpdatePositionNotes $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePositionNotes($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFeedsData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function updateFeedsData(\QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->updateFeedsData($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|\QCC\CampusM\CloudService\StructType\UpdateDirectoryListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
