<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named testUserLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\Login $payload
     * @return \QCC\CampusM\CloudService\StructType\LoginResponse|bool
     */
    public function testUserLogin(\QCC\CampusM\CloudService\StructType\Login $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->testUserLogin($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named testAsync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\TestAsyncRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function testAsync(\QCC\CampusM\CloudService\StructType\TestAsyncRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->testAsync($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\LoginResponse|\QCC\CampusM\CloudService\StructType\ReturnStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
