<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendJobAlertsService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SendJobAlerts $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function sendJobAlertsService(\QCC\CampusM\CloudService\StructType\SendJobAlerts $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->sendJobAlertsService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSchoolAlertsService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SendSchoolAlerts $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function sendSchoolAlertsService(\QCC\CampusM\CloudService\StructType\SendSchoolAlerts $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->sendSchoolAlertsService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendNotifications
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SendNotificationsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function sendNotifications(\QCC\CampusM\CloudService\StructType\SendNotificationsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->sendNotifications($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendAlerts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SendAlertsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function sendAlerts(\QCC\CampusM\CloudService\StructType\SendAlertsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->sendAlerts($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendAlertEmails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SendAlertEmailsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\SendAlertEmailsResponse|bool
     */
    public function sendAlertEmails(\QCC\CampusM\CloudService\StructType\SendAlertEmailsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->sendAlertEmails($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendIntegratedAlerts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function sendIntegratedAlerts(\QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->sendIntegratedAlerts($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendRssAlertsService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SendRssAlerts $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function sendRssAlertsService(\QCC\CampusM\CloudService\StructType\SendRssAlerts $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->sendRssAlertsService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|\QCC\CampusM\CloudService\StructType\SendAlertEmailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
