<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named saveJobPreferencesService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SaveJobPreferences $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function saveJobPreferencesService(\QCC\CampusM\CloudService\StructType\SaveJobPreferences $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->saveJobPreferencesService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveJobVacanciesService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SaveJobVacancies $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function saveJobVacanciesService(\QCC\CampusM\CloudService\StructType\SaveJobVacancies $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->saveJobVacanciesService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
