<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for News ServiceType
 * @subpackage Services
 */
class News extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named newsEvents
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\NewsEventsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\NewsEventsResponse|bool
     */
    public function newsEvents(\QCC\CampusM\CloudService\StructType\NewsEventsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->newsEvents($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\NewsEventsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
