<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Host ServiceType
 * @subpackage Services
 */
class Host extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hostConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\HostConfigRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\HostConfigResponse|bool
     */
    public function hostConfig(\QCC\CampusM\CloudService\StructType\HostConfigRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->hostConfig($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\HostConfigResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
