<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getJobPreferencesService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\GetJobPreferences $payload
     * @return \QCC\CampusM\CloudService\StructType\GetJobPreferencesResponse|bool
     */
    public function getJobPreferencesService(\QCC\CampusM\CloudService\StructType\GetJobPreferences $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->getJobPreferencesService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCurrentProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\GetCurrentProfileRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\GetCurrentProfileResponse|bool
     */
    public function getCurrentProfile(\QCC\CampusM\CloudService\StructType\GetCurrentProfileRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->getCurrentProfile($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResources
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\GetResourcesRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\GetResourcesResponse|bool
     */
    public function getResources(\QCC\CampusM\CloudService\StructType\GetResourcesRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->getResources($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRefLookups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\GetRefLookupsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\GetRefLookupsResponse|bool
     */
    public function getRefLookups(\QCC\CampusM\CloudService\StructType\GetRefLookupsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->getRefLookups($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeedItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\GetFeedItemsResponse|bool
     */
    public function getFeedItems(\QCC\CampusM\CloudService\StructType\GetFeedItemsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeedItems($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPersonalisationConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\GetPersonalisationConfigRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\GetPersonalisationConfigResponse|bool
     */
    public function getPersonalisationConfig(\QCC\CampusM\CloudService\StructType\GetPersonalisationConfigRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->getPersonalisationConfig($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\GetCurrentProfileResponse|\QCC\CampusM\CloudService\StructType\GetFeedItemsResponse|\QCC\CampusM\CloudService\StructType\GetJobPreferencesResponse|\QCC\CampusM\CloudService\StructType\GetPersonalisationConfigResponse|\QCC\CampusM\CloudService\StructType\GetRefLookupsResponse|\QCC\CampusM\CloudService\StructType\GetResourcesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
