<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Educause ServiceType
 * @subpackage Services
 */
class Educause extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named educauseSyncItinerary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\EducauseSyncItineraryRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\EducauseSyncItineraryResponse|bool
     */
    public function educauseSyncItinerary(\QCC\CampusM\CloudService\StructType\EducauseSyncItineraryRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->educauseSyncItinerary($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\EducauseSyncItineraryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
