<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\DeleteUserRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\DeleteUserResponse|bool
     */
    public function deleteUser(\QCC\CampusM\CloudService\StructType\DeleteUserRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteUser($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteAlerts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\DeleteAlertsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function deleteAlerts(\QCC\CampusM\CloudService\StructType\DeleteAlertsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteAlerts($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\DeleteUserResponse|\QCC\CampusM\CloudService\StructType\ReturnStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
