<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Del ServiceType
 * @subpackage Services
 */
class Del extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named delBookmark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\DeleteBookmarkRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\DeleteBookmarkResponse|bool
     */
    public function delBookmark(\QCC\CampusM\CloudService\StructType\DeleteBookmarkRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->delBookmark($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\DeleteBookmarkResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
