<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cached ServiceType
 * @subpackage Services
 */
class Cached extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cachedMapPosition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\CachedMapPositionRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\CachedMapPositionResponse|bool
     */
    public function cachedMapPosition(\QCC\CampusM\CloudService\StructType\CachedMapPositionRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->cachedMapPosition($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cachedPocketGuide
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\CachedPocketGuide $payload
     * @return \QCC\CampusM\CloudService\StructType\CachedPocketGuideResponse|bool
     */
    public function cachedPocketGuide(\QCC\CampusM\CloudService\StructType\CachedPocketGuide $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->cachedPocketGuide($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\CachedMapPositionResponse|\QCC\CampusM\CloudService\StructType\CachedPocketGuideResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
