<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Staff StructType
 * @subpackage Structs
 */
class Staff extends MBObject
{
    /**
     * The isMale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isMale;
    /**
     * The Appointments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAppointment
     */
    public $Appointments;
    /**
     * The Unavailabilities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUnavailability
     */
    public $Unavailabilities;
    /**
     * The Availabilities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAvailability
     */
    public $Availabilities;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The HomePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomePhone;
    /**
     * The WorkPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkPhone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The ForeignZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ForeignZip;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SortOrder;
    /**
     * The LoginLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLocation
     */
    public $LoginLocations;
    /**
     * The MultiLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MultiLocation;
    /**
     * The AppointmentTrn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AppointmentTrn;
    /**
     * The ReservationTrn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReservationTrn;
    /**
     * The IndependentContractor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IndependentContractor;
    /**
     * The AlwaysAllowDoubleBooking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AlwaysAllowDoubleBooking;
    /**
     * The UserAccessLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserAccessLevel;
    /**
     * The ProviderIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ProviderIDs;
    /**
     * The ProviderIDUpdateList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProviderIDUpdate
     */
    public $ProviderIDUpdateList;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The ImageURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageURL;
    /**
     * The Bio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bio;
    /**
     * Constructor method for Staff
     * @uses Staff::setIsMale()
     * @uses Staff::setAppointments()
     * @uses Staff::setUnavailabilities()
     * @uses Staff::setAvailabilities()
     * @uses Staff::setEmail()
     * @uses Staff::setMobilePhone()
     * @uses Staff::setHomePhone()
     * @uses Staff::setWorkPhone()
     * @uses Staff::setAddress()
     * @uses Staff::setAddress2()
     * @uses Staff::setCity()
     * @uses Staff::setState()
     * @uses Staff::setCountry()
     * @uses Staff::setPostalCode()
     * @uses Staff::setForeignZip()
     * @uses Staff::setSortOrder()
     * @uses Staff::setLoginLocations()
     * @uses Staff::setMultiLocation()
     * @uses Staff::setAppointmentTrn()
     * @uses Staff::setReservationTrn()
     * @uses Staff::setIndependentContractor()
     * @uses Staff::setAlwaysAllowDoubleBooking()
     * @uses Staff::setUserAccessLevel()
     * @uses Staff::setProviderIDs()
     * @uses Staff::setProviderIDUpdateList()
     * @uses Staff::setAction()
     * @uses Staff::setID()
     * @uses Staff::setName()
     * @uses Staff::setFirstName()
     * @uses Staff::setLastName()
     * @uses Staff::setImageURL()
     * @uses Staff::setBio()
     * @param bool $isMale
     * @param \ArrayType\ArrayOfAppointment $appointments
     * @param \ArrayType\ArrayOfUnavailability $unavailabilities
     * @param \ArrayType\ArrayOfAvailability $availabilities
     * @param string $email
     * @param string $mobilePhone
     * @param string $homePhone
     * @param string $workPhone
     * @param string $address
     * @param string $address2
     * @param string $city
     * @param string $state
     * @param string $country
     * @param string $postalCode
     * @param string $foreignZip
     * @param int $sortOrder
     * @param \ArrayType\ArrayOfLocation $loginLocations
     * @param bool $multiLocation
     * @param bool $appointmentTrn
     * @param bool $reservationTrn
     * @param bool $independentContractor
     * @param bool $alwaysAllowDoubleBooking
     * @param string $userAccessLevel
     * @param \ArrayType\ArrayOfString $providerIDs
     * @param \ArrayType\ArrayOfProviderIDUpdate $providerIDUpdateList
     * @param string $action
     * @param int $iD
     * @param string $name
     * @param string $firstName
     * @param string $lastName
     * @param string $imageURL
     * @param string $bio
     */
    public function __construct($isMale = null, \ArrayType\ArrayOfAppointment $appointments = null, \ArrayType\ArrayOfUnavailability $unavailabilities = null, \ArrayType\ArrayOfAvailability $availabilities = null, $email = null, $mobilePhone = null, $homePhone = null, $workPhone = null, $address = null, $address2 = null, $city = null, $state = null, $country = null, $postalCode = null, $foreignZip = null, $sortOrder = null, \ArrayType\ArrayOfLocation $loginLocations = null, $multiLocation = null, $appointmentTrn = null, $reservationTrn = null, $independentContractor = null, $alwaysAllowDoubleBooking = null, $userAccessLevel = null, \ArrayType\ArrayOfString $providerIDs = null, \ArrayType\ArrayOfProviderIDUpdate $providerIDUpdateList = null, $action = null, $iD = null, $name = null, $firstName = null, $lastName = null, $imageURL = null, $bio = null)
    {
        $this
            ->setIsMale($isMale)
            ->setAppointments($appointments)
            ->setUnavailabilities($unavailabilities)
            ->setAvailabilities($availabilities)
            ->setEmail($email)
            ->setMobilePhone($mobilePhone)
            ->setHomePhone($homePhone)
            ->setWorkPhone($workPhone)
            ->setAddress($address)
            ->setAddress2($address2)
            ->setCity($city)
            ->setState($state)
            ->setCountry($country)
            ->setPostalCode($postalCode)
            ->setForeignZip($foreignZip)
            ->setSortOrder($sortOrder)
            ->setLoginLocations($loginLocations)
            ->setMultiLocation($multiLocation)
            ->setAppointmentTrn($appointmentTrn)
            ->setReservationTrn($reservationTrn)
            ->setIndependentContractor($independentContractor)
            ->setAlwaysAllowDoubleBooking($alwaysAllowDoubleBooking)
            ->setUserAccessLevel($userAccessLevel)
            ->setProviderIDs($providerIDs)
            ->setProviderIDUpdateList($providerIDUpdateList)
            ->setAction($action)
            ->setID($iD)
            ->setName($name)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setImageURL($imageURL)
            ->setBio($bio);
    }
    /**
     * Get isMale value
     * @return bool
     */
    public function getIsMale()
    {
        return $this->isMale;
    }
    /**
     * Set isMale value
     * @param bool $isMale
     * @return \StructType\Staff
     */
    public function setIsMale($isMale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMale) && !is_bool($isMale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMale)), __LINE__);
        }
        $this->isMale = $isMale;
        return $this;
    }
    /**
     * Get Appointments value
     * @return \ArrayType\ArrayOfAppointment|null
     */
    public function getAppointments()
    {
        return $this->Appointments;
    }
    /**
     * Set Appointments value
     * @param \ArrayType\ArrayOfAppointment $appointments
     * @return \StructType\Staff
     */
    public function setAppointments(\ArrayType\ArrayOfAppointment $appointments = null)
    {
        $this->Appointments = $appointments;
        return $this;
    }
    /**
     * Get Unavailabilities value
     * @return \ArrayType\ArrayOfUnavailability|null
     */
    public function getUnavailabilities()
    {
        return $this->Unavailabilities;
    }
    /**
     * Set Unavailabilities value
     * @param \ArrayType\ArrayOfUnavailability $unavailabilities
     * @return \StructType\Staff
     */
    public function setUnavailabilities(\ArrayType\ArrayOfUnavailability $unavailabilities = null)
    {
        $this->Unavailabilities = $unavailabilities;
        return $this;
    }
    /**
     * Get Availabilities value
     * @return \ArrayType\ArrayOfAvailability|null
     */
    public function getAvailabilities()
    {
        return $this->Availabilities;
    }
    /**
     * Set Availabilities value
     * @param \ArrayType\ArrayOfAvailability $availabilities
     * @return \StructType\Staff
     */
    public function setAvailabilities(\ArrayType\ArrayOfAvailability $availabilities = null)
    {
        $this->Availabilities = $availabilities;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Staff
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\Staff
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get HomePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->HomePhone;
    }
    /**
     * Set HomePhone value
     * @param string $homePhone
     * @return \StructType\Staff
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homePhone)), __LINE__);
        }
        $this->HomePhone = $homePhone;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Staff
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\Staff
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\Staff
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Staff
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\Staff
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Staff
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Staff
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get ForeignZip value
     * @return string|null
     */
    public function getForeignZip()
    {
        return $this->ForeignZip;
    }
    /**
     * Set ForeignZip value
     * @param string $foreignZip
     * @return \StructType\Staff
     */
    public function setForeignZip($foreignZip = null)
    {
        // validation for constraint: string
        if (!is_null($foreignZip) && !is_string($foreignZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignZip)), __LINE__);
        }
        $this->ForeignZip = $foreignZip;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \StructType\Staff
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get LoginLocations value
     * @return \ArrayType\ArrayOfLocation|null
     */
    public function getLoginLocations()
    {
        return $this->LoginLocations;
    }
    /**
     * Set LoginLocations value
     * @param \ArrayType\ArrayOfLocation $loginLocations
     * @return \StructType\Staff
     */
    public function setLoginLocations(\ArrayType\ArrayOfLocation $loginLocations = null)
    {
        $this->LoginLocations = $loginLocations;
        return $this;
    }
    /**
     * Get MultiLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMultiLocation()
    {
        return isset($this->MultiLocation) ? $this->MultiLocation : null;
    }
    /**
     * Set MultiLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $multiLocation
     * @return \StructType\Staff
     */
    public function setMultiLocation($multiLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiLocation) && !is_bool($multiLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($multiLocation)), __LINE__);
        }
        if (is_null($multiLocation) || (is_array($multiLocation) && empty($multiLocation))) {
            unset($this->MultiLocation);
        } else {
            $this->MultiLocation = $multiLocation;
        }
        return $this;
    }
    /**
     * Get AppointmentTrn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAppointmentTrn()
    {
        return isset($this->AppointmentTrn) ? $this->AppointmentTrn : null;
    }
    /**
     * Set AppointmentTrn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $appointmentTrn
     * @return \StructType\Staff
     */
    public function setAppointmentTrn($appointmentTrn = null)
    {
        // validation for constraint: boolean
        if (!is_null($appointmentTrn) && !is_bool($appointmentTrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($appointmentTrn)), __LINE__);
        }
        if (is_null($appointmentTrn) || (is_array($appointmentTrn) && empty($appointmentTrn))) {
            unset($this->AppointmentTrn);
        } else {
            $this->AppointmentTrn = $appointmentTrn;
        }
        return $this;
    }
    /**
     * Get ReservationTrn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReservationTrn()
    {
        return isset($this->ReservationTrn) ? $this->ReservationTrn : null;
    }
    /**
     * Set ReservationTrn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reservationTrn
     * @return \StructType\Staff
     */
    public function setReservationTrn($reservationTrn = null)
    {
        // validation for constraint: boolean
        if (!is_null($reservationTrn) && !is_bool($reservationTrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reservationTrn)), __LINE__);
        }
        if (is_null($reservationTrn) || (is_array($reservationTrn) && empty($reservationTrn))) {
            unset($this->ReservationTrn);
        } else {
            $this->ReservationTrn = $reservationTrn;
        }
        return $this;
    }
    /**
     * Get IndependentContractor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIndependentContractor()
    {
        return isset($this->IndependentContractor) ? $this->IndependentContractor : null;
    }
    /**
     * Set IndependentContractor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $independentContractor
     * @return \StructType\Staff
     */
    public function setIndependentContractor($independentContractor = null)
    {
        // validation for constraint: boolean
        if (!is_null($independentContractor) && !is_bool($independentContractor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($independentContractor)), __LINE__);
        }
        if (is_null($independentContractor) || (is_array($independentContractor) && empty($independentContractor))) {
            unset($this->IndependentContractor);
        } else {
            $this->IndependentContractor = $independentContractor;
        }
        return $this;
    }
    /**
     * Get AlwaysAllowDoubleBooking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAlwaysAllowDoubleBooking()
    {
        return isset($this->AlwaysAllowDoubleBooking) ? $this->AlwaysAllowDoubleBooking : null;
    }
    /**
     * Set AlwaysAllowDoubleBooking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $alwaysAllowDoubleBooking
     * @return \StructType\Staff
     */
    public function setAlwaysAllowDoubleBooking($alwaysAllowDoubleBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($alwaysAllowDoubleBooking) && !is_bool($alwaysAllowDoubleBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alwaysAllowDoubleBooking)), __LINE__);
        }
        if (is_null($alwaysAllowDoubleBooking) || (is_array($alwaysAllowDoubleBooking) && empty($alwaysAllowDoubleBooking))) {
            unset($this->AlwaysAllowDoubleBooking);
        } else {
            $this->AlwaysAllowDoubleBooking = $alwaysAllowDoubleBooking;
        }
        return $this;
    }
    /**
     * Get UserAccessLevel value
     * @return string|null
     */
    public function getUserAccessLevel()
    {
        return $this->UserAccessLevel;
    }
    /**
     * Set UserAccessLevel value
     * @param string $userAccessLevel
     * @return \StructType\Staff
     */
    public function setUserAccessLevel($userAccessLevel = null)
    {
        // validation for constraint: string
        if (!is_null($userAccessLevel) && !is_string($userAccessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userAccessLevel)), __LINE__);
        }
        $this->UserAccessLevel = $userAccessLevel;
        return $this;
    }
    /**
     * Get ProviderIDs value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getProviderIDs()
    {
        return $this->ProviderIDs;
    }
    /**
     * Set ProviderIDs value
     * @param \ArrayType\ArrayOfString $providerIDs
     * @return \StructType\Staff
     */
    public function setProviderIDs(\ArrayType\ArrayOfString $providerIDs = null)
    {
        $this->ProviderIDs = $providerIDs;
        return $this;
    }
    /**
     * Get ProviderIDUpdateList value
     * @return \ArrayType\ArrayOfProviderIDUpdate|null
     */
    public function getProviderIDUpdateList()
    {
        return $this->ProviderIDUpdateList;
    }
    /**
     * Set ProviderIDUpdateList value
     * @param \ArrayType\ArrayOfProviderIDUpdate $providerIDUpdateList
     * @return \StructType\Staff
     */
    public function setProviderIDUpdateList(\ArrayType\ArrayOfProviderIDUpdate $providerIDUpdateList = null)
    {
        $this->ProviderIDUpdateList = $providerIDUpdateList;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionCode::valueIsValid()
     * @uses \EnumType\ActionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\Staff
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionCode::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\ActionCode::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iD
     * @return \StructType\Staff
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Staff
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Staff
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Staff
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get ImageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->ImageURL;
    }
    /**
     * Set ImageURL value
     * @param string $imageURL
     * @return \StructType\Staff
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        $this->ImageURL = $imageURL;
        return $this;
    }
    /**
     * Get Bio value
     * @return string|null
     */
    public function getBio()
    {
        return $this->Bio;
    }
    /**
     * Set Bio value
     * @param string $bio
     * @return \StructType\Staff
     */
    public function setBio($bio = null)
    {
        // validation for constraint: string
        if (!is_null($bio) && !is_string($bio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bio)), __LINE__);
        }
        $this->Bio = $bio;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Staff
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
