<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceCredentials StructType
 * @subpackage Structs
 */
class SourceCredentials extends AbstractStructBase
{
    /**
     * The SourceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The SiteIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $SiteIDs;
    /**
     * Constructor method for SourceCredentials
     * @uses SourceCredentials::setSourceName()
     * @uses SourceCredentials::setPassword()
     * @uses SourceCredentials::setSiteIDs()
     * @param string $sourceName
     * @param string $password
     * @param \ArrayType\ArrayOfInt $siteIDs
     */
    public function __construct($sourceName = null, $password = null, \ArrayType\ArrayOfInt $siteIDs = null)
    {
        $this
            ->setSourceName($sourceName)
            ->setPassword($password)
            ->setSiteIDs($siteIDs);
    }
    /**
     * Get SourceName value
     * @return string|null
     */
    public function getSourceName()
    {
        return $this->SourceName;
    }
    /**
     * Set SourceName value
     * @param string $sourceName
     * @return \StructType\SourceCredentials
     */
    public function setSourceName($sourceName = null)
    {
        // validation for constraint: string
        if (!is_null($sourceName) && !is_string($sourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceName)), __LINE__);
        }
        $this->SourceName = $sourceName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\SourceCredentials
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SiteIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getSiteIDs()
    {
        return $this->SiteIDs;
    }
    /**
     * Set SiteIDs value
     * @param \ArrayType\ArrayOfInt $siteIDs
     * @return \StructType\SourceCredentials
     */
    public function setSiteIDs(\ArrayType\ArrayOfInt $siteIDs = null)
    {
        $this->SiteIDs = $siteIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SourceCredentials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
