<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Site StructType
 * @subpackage Structs
 */
class Site extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The LogoURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LogoURL;
    /**
     * The PageColor1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PageColor1;
    /**
     * The PageColor2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PageColor2;
    /**
     * The PageColor3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PageColor3;
    /**
     * The PageColor4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PageColor4;
    /**
     * The AcceptsVisa
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AcceptsVisa;
    /**
     * The AcceptsDiscover
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AcceptsDiscover;
    /**
     * The AcceptsMasterCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AcceptsMasterCard;
    /**
     * The AcceptsAmericanExpress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AcceptsAmericanExpress;
    /**
     * The ContactEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmail;
    /**
     * The ESA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ESA;
    /**
     * The TotalWOD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TotalWOD;
    /**
     * The TaxInclusivePrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TaxInclusivePrices;
    /**
     * The SMSPackageEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SMSPackageEnabled;
    /**
     * The AllowsDashboardAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AllowsDashboardAccess;
    /**
     * The PricingLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricingLevel;
    /**
     * Constructor method for Site
     * @uses Site::setID()
     * @uses Site::setName()
     * @uses Site::setDescription()
     * @uses Site::setLogoURL()
     * @uses Site::setPageColor1()
     * @uses Site::setPageColor2()
     * @uses Site::setPageColor3()
     * @uses Site::setPageColor4()
     * @uses Site::setAcceptsVisa()
     * @uses Site::setAcceptsDiscover()
     * @uses Site::setAcceptsMasterCard()
     * @uses Site::setAcceptsAmericanExpress()
     * @uses Site::setContactEmail()
     * @uses Site::setESA()
     * @uses Site::setTotalWOD()
     * @uses Site::setTaxInclusivePrices()
     * @uses Site::setSMSPackageEnabled()
     * @uses Site::setAllowsDashboardAccess()
     * @uses Site::setPricingLevel()
     * @param int $iD
     * @param string $name
     * @param string $description
     * @param string $logoURL
     * @param string $pageColor1
     * @param string $pageColor2
     * @param string $pageColor3
     * @param string $pageColor4
     * @param bool $acceptsVisa
     * @param bool $acceptsDiscover
     * @param bool $acceptsMasterCard
     * @param bool $acceptsAmericanExpress
     * @param string $contactEmail
     * @param bool $eSA
     * @param bool $totalWOD
     * @param bool $taxInclusivePrices
     * @param bool $sMSPackageEnabled
     * @param bool $allowsDashboardAccess
     * @param string $pricingLevel
     */
    public function __construct($iD = null, $name = null, $description = null, $logoURL = null, $pageColor1 = null, $pageColor2 = null, $pageColor3 = null, $pageColor4 = null, $acceptsVisa = null, $acceptsDiscover = null, $acceptsMasterCard = null, $acceptsAmericanExpress = null, $contactEmail = null, $eSA = null, $totalWOD = null, $taxInclusivePrices = null, $sMSPackageEnabled = null, $allowsDashboardAccess = null, $pricingLevel = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setDescription($description)
            ->setLogoURL($logoURL)
            ->setPageColor1($pageColor1)
            ->setPageColor2($pageColor2)
            ->setPageColor3($pageColor3)
            ->setPageColor4($pageColor4)
            ->setAcceptsVisa($acceptsVisa)
            ->setAcceptsDiscover($acceptsDiscover)
            ->setAcceptsMasterCard($acceptsMasterCard)
            ->setAcceptsAmericanExpress($acceptsAmericanExpress)
            ->setContactEmail($contactEmail)
            ->setESA($eSA)
            ->setTotalWOD($totalWOD)
            ->setTaxInclusivePrices($taxInclusivePrices)
            ->setSMSPackageEnabled($sMSPackageEnabled)
            ->setAllowsDashboardAccess($allowsDashboardAccess)
            ->setPricingLevel($pricingLevel);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Site
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Site
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Site
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get LogoURL value
     * @return string|null
     */
    public function getLogoURL()
    {
        return $this->LogoURL;
    }
    /**
     * Set LogoURL value
     * @param string $logoURL
     * @return \StructType\Site
     */
    public function setLogoURL($logoURL = null)
    {
        // validation for constraint: string
        if (!is_null($logoURL) && !is_string($logoURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logoURL)), __LINE__);
        }
        $this->LogoURL = $logoURL;
        return $this;
    }
    /**
     * Get PageColor1 value
     * @return string|null
     */
    public function getPageColor1()
    {
        return $this->PageColor1;
    }
    /**
     * Set PageColor1 value
     * @param string $pageColor1
     * @return \StructType\Site
     */
    public function setPageColor1($pageColor1 = null)
    {
        // validation for constraint: string
        if (!is_null($pageColor1) && !is_string($pageColor1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageColor1)), __LINE__);
        }
        $this->PageColor1 = $pageColor1;
        return $this;
    }
    /**
     * Get PageColor2 value
     * @return string|null
     */
    public function getPageColor2()
    {
        return $this->PageColor2;
    }
    /**
     * Set PageColor2 value
     * @param string $pageColor2
     * @return \StructType\Site
     */
    public function setPageColor2($pageColor2 = null)
    {
        // validation for constraint: string
        if (!is_null($pageColor2) && !is_string($pageColor2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageColor2)), __LINE__);
        }
        $this->PageColor2 = $pageColor2;
        return $this;
    }
    /**
     * Get PageColor3 value
     * @return string|null
     */
    public function getPageColor3()
    {
        return $this->PageColor3;
    }
    /**
     * Set PageColor3 value
     * @param string $pageColor3
     * @return \StructType\Site
     */
    public function setPageColor3($pageColor3 = null)
    {
        // validation for constraint: string
        if (!is_null($pageColor3) && !is_string($pageColor3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageColor3)), __LINE__);
        }
        $this->PageColor3 = $pageColor3;
        return $this;
    }
    /**
     * Get PageColor4 value
     * @return string|null
     */
    public function getPageColor4()
    {
        return $this->PageColor4;
    }
    /**
     * Set PageColor4 value
     * @param string $pageColor4
     * @return \StructType\Site
     */
    public function setPageColor4($pageColor4 = null)
    {
        // validation for constraint: string
        if (!is_null($pageColor4) && !is_string($pageColor4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageColor4)), __LINE__);
        }
        $this->PageColor4 = $pageColor4;
        return $this;
    }
    /**
     * Get AcceptsVisa value
     * @return bool|null
     */
    public function getAcceptsVisa()
    {
        return $this->AcceptsVisa;
    }
    /**
     * Set AcceptsVisa value
     * @param bool $acceptsVisa
     * @return \StructType\Site
     */
    public function setAcceptsVisa($acceptsVisa = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptsVisa) && !is_bool($acceptsVisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acceptsVisa)), __LINE__);
        }
        $this->AcceptsVisa = $acceptsVisa;
        return $this;
    }
    /**
     * Get AcceptsDiscover value
     * @return bool|null
     */
    public function getAcceptsDiscover()
    {
        return $this->AcceptsDiscover;
    }
    /**
     * Set AcceptsDiscover value
     * @param bool $acceptsDiscover
     * @return \StructType\Site
     */
    public function setAcceptsDiscover($acceptsDiscover = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptsDiscover) && !is_bool($acceptsDiscover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acceptsDiscover)), __LINE__);
        }
        $this->AcceptsDiscover = $acceptsDiscover;
        return $this;
    }
    /**
     * Get AcceptsMasterCard value
     * @return bool|null
     */
    public function getAcceptsMasterCard()
    {
        return $this->AcceptsMasterCard;
    }
    /**
     * Set AcceptsMasterCard value
     * @param bool $acceptsMasterCard
     * @return \StructType\Site
     */
    public function setAcceptsMasterCard($acceptsMasterCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptsMasterCard) && !is_bool($acceptsMasterCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acceptsMasterCard)), __LINE__);
        }
        $this->AcceptsMasterCard = $acceptsMasterCard;
        return $this;
    }
    /**
     * Get AcceptsAmericanExpress value
     * @return bool|null
     */
    public function getAcceptsAmericanExpress()
    {
        return $this->AcceptsAmericanExpress;
    }
    /**
     * Set AcceptsAmericanExpress value
     * @param bool $acceptsAmericanExpress
     * @return \StructType\Site
     */
    public function setAcceptsAmericanExpress($acceptsAmericanExpress = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptsAmericanExpress) && !is_bool($acceptsAmericanExpress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acceptsAmericanExpress)), __LINE__);
        }
        $this->AcceptsAmericanExpress = $acceptsAmericanExpress;
        return $this;
    }
    /**
     * Get ContactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->ContactEmail;
    }
    /**
     * Set ContactEmail value
     * @param string $contactEmail
     * @return \StructType\Site
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactEmail)), __LINE__);
        }
        $this->ContactEmail = $contactEmail;
        return $this;
    }
    /**
     * Get ESA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getESA()
    {
        return isset($this->ESA) ? $this->ESA : null;
    }
    /**
     * Set ESA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $eSA
     * @return \StructType\Site
     */
    public function setESA($eSA = null)
    {
        // validation for constraint: boolean
        if (!is_null($eSA) && !is_bool($eSA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($eSA)), __LINE__);
        }
        if (is_null($eSA) || (is_array($eSA) && empty($eSA))) {
            unset($this->ESA);
        } else {
            $this->ESA = $eSA;
        }
        return $this;
    }
    /**
     * Get TotalWOD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTotalWOD()
    {
        return isset($this->TotalWOD) ? $this->TotalWOD : null;
    }
    /**
     * Set TotalWOD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $totalWOD
     * @return \StructType\Site
     */
    public function setTotalWOD($totalWOD = null)
    {
        // validation for constraint: boolean
        if (!is_null($totalWOD) && !is_bool($totalWOD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($totalWOD)), __LINE__);
        }
        if (is_null($totalWOD) || (is_array($totalWOD) && empty($totalWOD))) {
            unset($this->TotalWOD);
        } else {
            $this->TotalWOD = $totalWOD;
        }
        return $this;
    }
    /**
     * Get TaxInclusivePrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTaxInclusivePrices()
    {
        return isset($this->TaxInclusivePrices) ? $this->TaxInclusivePrices : null;
    }
    /**
     * Set TaxInclusivePrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $taxInclusivePrices
     * @return \StructType\Site
     */
    public function setTaxInclusivePrices($taxInclusivePrices = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusivePrices) && !is_bool($taxInclusivePrices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusivePrices)), __LINE__);
        }
        if (is_null($taxInclusivePrices) || (is_array($taxInclusivePrices) && empty($taxInclusivePrices))) {
            unset($this->TaxInclusivePrices);
        } else {
            $this->TaxInclusivePrices = $taxInclusivePrices;
        }
        return $this;
    }
    /**
     * Get SMSPackageEnabled value
     * @return bool|null
     */
    public function getSMSPackageEnabled()
    {
        return $this->SMSPackageEnabled;
    }
    /**
     * Set SMSPackageEnabled value
     * @param bool $sMSPackageEnabled
     * @return \StructType\Site
     */
    public function setSMSPackageEnabled($sMSPackageEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($sMSPackageEnabled) && !is_bool($sMSPackageEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sMSPackageEnabled)), __LINE__);
        }
        $this->SMSPackageEnabled = $sMSPackageEnabled;
        return $this;
    }
    /**
     * Get AllowsDashboardAccess value
     * @return bool|null
     */
    public function getAllowsDashboardAccess()
    {
        return $this->AllowsDashboardAccess;
    }
    /**
     * Set AllowsDashboardAccess value
     * @param bool $allowsDashboardAccess
     * @return \StructType\Site
     */
    public function setAllowsDashboardAccess($allowsDashboardAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowsDashboardAccess) && !is_bool($allowsDashboardAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowsDashboardAccess)), __LINE__);
        }
        $this->AllowsDashboardAccess = $allowsDashboardAccess;
        return $this;
    }
    /**
     * Get PricingLevel value
     * @return string|null
     */
    public function getPricingLevel()
    {
        return $this->PricingLevel;
    }
    /**
     * Set PricingLevel value
     * @param string $pricingLevel
     * @return \StructType\Site
     */
    public function setPricingLevel($pricingLevel = null)
    {
        // validation for constraint: string
        if (!is_null($pricingLevel) && !is_string($pricingLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pricingLevel)), __LINE__);
        }
        $this->PricingLevel = $pricingLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Site
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
