<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleItem StructType
 * @subpackage Structs
 */
class SaleItem extends MBObject
{
    /**
     * The Sale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sale
     */
    public $Sale;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AccountPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AccountPayment;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $AmountPaid;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Discount;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Tax;
    /**
     * The Returned
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Returned;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for SaleItem
     * @uses SaleItem::setSale()
     * @uses SaleItem::setDescription()
     * @uses SaleItem::setAccountPayment()
     * @uses SaleItem::setPrice()
     * @uses SaleItem::setAmountPaid()
     * @uses SaleItem::setDiscount()
     * @uses SaleItem::setTax()
     * @uses SaleItem::setReturned()
     * @uses SaleItem::setQuantity()
     * @param \StructType\Sale $sale
     * @param string $description
     * @param bool $accountPayment
     * @param float $price
     * @param float $amountPaid
     * @param float $discount
     * @param float $tax
     * @param bool $returned
     * @param int $quantity
     */
    public function __construct(\StructType\Sale $sale = null, $description = null, $accountPayment = null, $price = null, $amountPaid = null, $discount = null, $tax = null, $returned = null, $quantity = null)
    {
        $this
            ->setSale($sale)
            ->setDescription($description)
            ->setAccountPayment($accountPayment)
            ->setPrice($price)
            ->setAmountPaid($amountPaid)
            ->setDiscount($discount)
            ->setTax($tax)
            ->setReturned($returned)
            ->setQuantity($quantity);
    }
    /**
     * Get Sale value
     * @return \StructType\Sale|null
     */
    public function getSale()
    {
        return $this->Sale;
    }
    /**
     * Set Sale value
     * @param \StructType\Sale $sale
     * @return \StructType\SaleItem
     */
    public function setSale(\StructType\Sale $sale = null)
    {
        $this->Sale = $sale;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SaleItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AccountPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccountPayment()
    {
        return isset($this->AccountPayment) ? $this->AccountPayment : null;
    }
    /**
     * Set AccountPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accountPayment
     * @return \StructType\SaleItem
     */
    public function setAccountPayment($accountPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountPayment) && !is_bool($accountPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accountPayment)), __LINE__);
        }
        if (is_null($accountPayment) || (is_array($accountPayment) && empty($accountPayment))) {
            unset($this->AccountPayment);
        } else {
            $this->AccountPayment = $accountPayment;
        }
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\SaleItem
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get AmountPaid value
     * @return float|null
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param float $amountPaid
     * @return \StructType\SaleItem
     */
    public function setAmountPaid($amountPaid = null)
    {
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get Discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\SaleItem
     */
    public function setDiscount($discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Tax value
     * @return float|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \StructType\SaleItem
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get Returned value
     * @return bool|null
     */
    public function getReturned()
    {
        return $this->Returned;
    }
    /**
     * Set Returned value
     * @param bool $returned
     * @return \StructType\SaleItem
     */
    public function setReturned($returned = null)
    {
        // validation for constraint: boolean
        if (!is_null($returned) && !is_bool($returned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returned)), __LINE__);
        }
        $this->Returned = $returned;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\SaleItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
