<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rep StructType
 * @subpackage Structs
 */
class Rep extends MBObject
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The Staff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Staff
     */
    public $Staff;
    /**
     * Constructor method for Rep
     * @uses Rep::setID()
     * @uses Rep::setStaff()
     * @param int $iD
     * @param \StructType\Staff $staff
     */
    public function __construct($iD = null, \StructType\Staff $staff = null)
    {
        $this
            ->setID($iD)
            ->setStaff($staff);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Rep
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Staff value
     * @return \StructType\Staff|null
     */
    public function getStaff()
    {
        return $this->Staff;
    }
    /**
     * Set Staff value
     * @param \StructType\Staff $staff
     * @return \StructType\Rep
     */
    public function setStaff(\StructType\Staff $staff = null)
    {
        $this->Staff = $staff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rep
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
