<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Relationship StructType
 * @subpackage Structs
 */
class Relationship extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The RelationshipName1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelationshipName1;
    /**
     * The RelationshipName2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelationshipName2;
    /**
     * Constructor method for Relationship
     * @uses Relationship::setID()
     * @uses Relationship::setRelationshipName1()
     * @uses Relationship::setRelationshipName2()
     * @param int $iD
     * @param string $relationshipName1
     * @param string $relationshipName2
     */
    public function __construct($iD = null, $relationshipName1 = null, $relationshipName2 = null)
    {
        $this
            ->setID($iD)
            ->setRelationshipName1($relationshipName1)
            ->setRelationshipName2($relationshipName2);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Relationship
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RelationshipName1 value
     * @return string|null
     */
    public function getRelationshipName1()
    {
        return $this->RelationshipName1;
    }
    /**
     * Set RelationshipName1 value
     * @param string $relationshipName1
     * @return \StructType\Relationship
     */
    public function setRelationshipName1($relationshipName1 = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipName1) && !is_string($relationshipName1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relationshipName1)), __LINE__);
        }
        $this->RelationshipName1 = $relationshipName1;
        return $this;
    }
    /**
     * Get RelationshipName2 value
     * @return string|null
     */
    public function getRelationshipName2()
    {
        return $this->RelationshipName2;
    }
    /**
     * Set RelationshipName2 value
     * @param string $relationshipName2
     * @return \StructType\Relationship
     */
    public function setRelationshipName2($relationshipName2 = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipName2) && !is_string($relationshipName2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relationshipName2)), __LINE__);
        }
        $this->RelationshipName2 = $relationshipName2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Relationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
