<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagedBySitesMBResult StructType
 * @subpackage Structs
 */
class PagedBySitesMBResult extends MBResult
{
    /**
     * The ClientAssociatedSitesOffset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClientAssociatedSitesOffset;
    /**
     * The ClientAssociatedSitesTotalResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClientAssociatedSitesTotalResults;
    /**
     * Constructor method for PagedBySitesMBResult
     * @uses PagedBySitesMBResult::setClientAssociatedSitesOffset()
     * @uses PagedBySitesMBResult::setClientAssociatedSitesTotalResults()
     * @param int $clientAssociatedSitesOffset
     * @param int $clientAssociatedSitesTotalResults
     */
    public function __construct($clientAssociatedSitesOffset = null, $clientAssociatedSitesTotalResults = null)
    {
        $this
            ->setClientAssociatedSitesOffset($clientAssociatedSitesOffset)
            ->setClientAssociatedSitesTotalResults($clientAssociatedSitesTotalResults);
    }
    /**
     * Get ClientAssociatedSitesOffset value
     * @return int
     */
    public function getClientAssociatedSitesOffset()
    {
        return $this->ClientAssociatedSitesOffset;
    }
    /**
     * Set ClientAssociatedSitesOffset value
     * @param int $clientAssociatedSitesOffset
     * @return \StructType\PagedBySitesMBResult
     */
    public function setClientAssociatedSitesOffset($clientAssociatedSitesOffset = null)
    {
        // validation for constraint: int
        if (!is_null($clientAssociatedSitesOffset) && !is_numeric($clientAssociatedSitesOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($clientAssociatedSitesOffset)), __LINE__);
        }
        $this->ClientAssociatedSitesOffset = $clientAssociatedSitesOffset;
        return $this;
    }
    /**
     * Get ClientAssociatedSitesTotalResults value
     * @return int
     */
    public function getClientAssociatedSitesTotalResults()
    {
        return $this->ClientAssociatedSitesTotalResults;
    }
    /**
     * Set ClientAssociatedSitesTotalResults value
     * @param int $clientAssociatedSitesTotalResults
     * @return \StructType\PagedBySitesMBResult
     */
    public function setClientAssociatedSitesTotalResults($clientAssociatedSitesTotalResults = null)
    {
        // validation for constraint: int
        if (!is_null($clientAssociatedSitesTotalResults) && !is_numeric($clientAssociatedSitesTotalResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($clientAssociatedSitesTotalResults)), __LINE__);
        }
        $this->ClientAssociatedSitesTotalResults = $clientAssociatedSitesTotalResults;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PagedBySitesMBResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
