<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientVisitsRequest StructType
 * @subpackage Structs
 */
class GetClientVisitsRequest extends PagedBySitesMBRequest
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The UnpaidsOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UnpaidsOnly;
    /**
     * The CrossRegionalLookup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CrossRegionalLookup;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * Constructor method for GetClientVisitsRequest
     * @uses GetClientVisitsRequest::setStartDate()
     * @uses GetClientVisitsRequest::setEndDate()
     * @uses GetClientVisitsRequest::setUnpaidsOnly()
     * @uses GetClientVisitsRequest::setCrossRegionalLookup()
     * @uses GetClientVisitsRequest::setClientID()
     * @param string $startDate
     * @param string $endDate
     * @param bool $unpaidsOnly
     * @param bool $crossRegionalLookup
     * @param string $clientID
     */
    public function __construct($startDate = null, $endDate = null, $unpaidsOnly = null, $crossRegionalLookup = null, $clientID = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setUnpaidsOnly($unpaidsOnly)
            ->setCrossRegionalLookup($crossRegionalLookup)
            ->setClientID($clientID);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\GetClientVisitsRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\GetClientVisitsRequest
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get UnpaidsOnly value
     * @return bool
     */
    public function getUnpaidsOnly()
    {
        return $this->UnpaidsOnly;
    }
    /**
     * Set UnpaidsOnly value
     * @param bool $unpaidsOnly
     * @return \StructType\GetClientVisitsRequest
     */
    public function setUnpaidsOnly($unpaidsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($unpaidsOnly) && !is_bool($unpaidsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unpaidsOnly)), __LINE__);
        }
        $this->UnpaidsOnly = $unpaidsOnly;
        return $this;
    }
    /**
     * Get CrossRegionalLookup value
     * @return bool
     */
    public function getCrossRegionalLookup()
    {
        return $this->CrossRegionalLookup;
    }
    /**
     * Set CrossRegionalLookup value
     * @param bool $crossRegionalLookup
     * @return \StructType\GetClientVisitsRequest
     */
    public function setCrossRegionalLookup($crossRegionalLookup = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossRegionalLookup) && !is_bool($crossRegionalLookup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($crossRegionalLookup)), __LINE__);
        }
        $this->CrossRegionalLookup = $crossRegionalLookup;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\GetClientVisitsRequest
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetClientVisitsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
