<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteCientFormulaNoteRequest StructType
 * @subpackage Structs
 */
class DeleteCientFormulaNoteRequest extends MBRequest
{
    /**
     * The FormulaNoteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FormulaNoteID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * Constructor method for DeleteCientFormulaNoteRequest
     * @uses DeleteCientFormulaNoteRequest::setFormulaNoteID()
     * @uses DeleteCientFormulaNoteRequest::setClientID()
     * @param int $formulaNoteID
     * @param string $clientID
     */
    public function __construct($formulaNoteID = null, $clientID = null)
    {
        $this
            ->setFormulaNoteID($formulaNoteID)
            ->setClientID($clientID);
    }
    /**
     * Get FormulaNoteID value
     * @return int
     */
    public function getFormulaNoteID()
    {
        return $this->FormulaNoteID;
    }
    /**
     * Set FormulaNoteID value
     * @param int $formulaNoteID
     * @return \StructType\DeleteCientFormulaNoteRequest
     */
    public function setFormulaNoteID($formulaNoteID = null)
    {
        // validation for constraint: int
        if (!is_null($formulaNoteID) && !is_numeric($formulaNoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($formulaNoteID)), __LINE__);
        }
        $this->FormulaNoteID = $formulaNoteID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\DeleteCientFormulaNoteRequest
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteCientFormulaNoteRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
