<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientRelationship StructType
 * @subpackage Structs
 */
class ClientRelationship extends MBObject
{
    /**
     * The RelatedClient
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Client
     */
    public $RelatedClient;
    /**
     * The Relationship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Relationship
     */
    public $Relationship;
    /**
     * The RelationshipName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelationshipName;
    /**
     * Constructor method for ClientRelationship
     * @uses ClientRelationship::setRelatedClient()
     * @uses ClientRelationship::setRelationship()
     * @uses ClientRelationship::setRelationshipName()
     * @param \StructType\Client $relatedClient
     * @param \StructType\Relationship $relationship
     * @param string $relationshipName
     */
    public function __construct(\StructType\Client $relatedClient = null, \StructType\Relationship $relationship = null, $relationshipName = null)
    {
        $this
            ->setRelatedClient($relatedClient)
            ->setRelationship($relationship)
            ->setRelationshipName($relationshipName);
    }
    /**
     * Get RelatedClient value
     * @return \StructType\Client|null
     */
    public function getRelatedClient()
    {
        return $this->RelatedClient;
    }
    /**
     * Set RelatedClient value
     * @param \StructType\Client $relatedClient
     * @return \StructType\ClientRelationship
     */
    public function setRelatedClient(\StructType\Client $relatedClient = null)
    {
        $this->RelatedClient = $relatedClient;
        return $this;
    }
    /**
     * Get Relationship value
     * @return \StructType\Relationship|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * Set Relationship value
     * @param \StructType\Relationship $relationship
     * @return \StructType\ClientRelationship
     */
    public function setRelationship(\StructType\Relationship $relationship = null)
    {
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Get RelationshipName value
     * @return string|null
     */
    public function getRelationshipName()
    {
        return $this->RelationshipName;
    }
    /**
     * Set RelationshipName value
     * @param string $relationshipName
     * @return \StructType\ClientRelationship
     */
    public function setRelationshipName($relationshipName = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipName) && !is_string($relationshipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relationshipName)), __LINE__);
        }
        $this->RelationshipName = $relationshipName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
