<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientIndex StructType
 * @subpackage Structs
 */
class ClientIndex extends MBObject
{
    /**
     * The RequiredBusinessMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RequiredBusinessMode;
    /**
     * The RequiredConsumerMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RequiredConsumerMode;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Values
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClientIndexValue
     */
    public $Values;
    /**
     * Constructor method for ClientIndex
     * @uses ClientIndex::setRequiredBusinessMode()
     * @uses ClientIndex::setRequiredConsumerMode()
     * @uses ClientIndex::setAction()
     * @uses ClientIndex::setID()
     * @uses ClientIndex::setName()
     * @uses ClientIndex::setValues()
     * @param bool $requiredBusinessMode
     * @param bool $requiredConsumerMode
     * @param string $action
     * @param int $iD
     * @param string $name
     * @param \ArrayType\ArrayOfClientIndexValue $values
     */
    public function __construct($requiredBusinessMode = null, $requiredConsumerMode = null, $action = null, $iD = null, $name = null, \ArrayType\ArrayOfClientIndexValue $values = null)
    {
        $this
            ->setRequiredBusinessMode($requiredBusinessMode)
            ->setRequiredConsumerMode($requiredConsumerMode)
            ->setAction($action)
            ->setID($iD)
            ->setName($name)
            ->setValues($values);
    }
    /**
     * Get RequiredBusinessMode value
     * @return bool|null
     */
    public function getRequiredBusinessMode()
    {
        return $this->RequiredBusinessMode;
    }
    /**
     * Set RequiredBusinessMode value
     * @param bool $requiredBusinessMode
     * @return \StructType\ClientIndex
     */
    public function setRequiredBusinessMode($requiredBusinessMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredBusinessMode) && !is_bool($requiredBusinessMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requiredBusinessMode)), __LINE__);
        }
        $this->RequiredBusinessMode = $requiredBusinessMode;
        return $this;
    }
    /**
     * Get RequiredConsumerMode value
     * @return bool|null
     */
    public function getRequiredConsumerMode()
    {
        return $this->RequiredConsumerMode;
    }
    /**
     * Set RequiredConsumerMode value
     * @param bool $requiredConsumerMode
     * @return \StructType\ClientIndex
     */
    public function setRequiredConsumerMode($requiredConsumerMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredConsumerMode) && !is_bool($requiredConsumerMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requiredConsumerMode)), __LINE__);
        }
        $this->RequiredConsumerMode = $requiredConsumerMode;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionCode::valueIsValid()
     * @uses \EnumType\ActionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\ClientIndex
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionCode::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\ActionCode::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iD
     * @return \StructType\ClientIndex
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ClientIndex
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Values value
     * @return \ArrayType\ArrayOfClientIndexValue|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \ArrayType\ArrayOfClientIndexValue $values
     * @return \StructType\ClientIndex
     */
    public function setValues(\ArrayType\ArrayOfClientIndexValue $values = null)
    {
        $this->Values = $values;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientIndex
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
