<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateClientCrossRegional
     * Meta informations extracted from the WSDL
     * - documentation: Updates a client's information and any cross-regional clients' information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateClientCrossRegional $parameters
     * @return \StructType\UpdateClientCrossRegionalResponse|bool
     */
    public function UpdateClientCrossRegional(\StructType\UpdateClientCrossRegional $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateClientCrossRegional($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateClientServices
     * Meta informations extracted from the WSDL
     * - documentation: Updates a client service for a given client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateClientServices $parameters
     * @return \StructType\UpdateClientServicesResponse|bool
     */
    public function UpdateClientServices(\StructType\UpdateClientServices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateClientServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateClientCrossRegionalResponse|\StructType\UpdateClientServicesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
