<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetClients
     * Meta informations extracted from the WSDL
     * - documentation: Gets a list of clients.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClients $parameters
     * @return \StructType\GetClientsResponse|bool
     */
    public function GetClients(\StructType\GetClients $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClients($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCrossRegionalClientAssociations
     * Meta informations extracted from the WSDL
     * - documentation: Gets a list of Client IDs representing the same client at different sites within the region.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCrossRegionalClientAssociations $parameters
     * @return \StructType\GetCrossRegionalClientAssociationsResponse|bool
     */
    public function GetCrossRegionalClientAssociations(\StructType\GetCrossRegionalClientAssociations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCrossRegionalClientAssociations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomClientFields
     * Meta informations extracted from the WSDL
     * - documentation: Gets a list of currently available client indexes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomClientFields $parameters
     * @return \StructType\GetCustomClientFieldsResponse|bool
     */
    public function GetCustomClientFields(\StructType\GetCustomClientFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomClientFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientIndexes
     * Meta informations extracted from the WSDL
     * - documentation: Gets a list of currently available client indexes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientIndexes $parameters
     * @return \StructType\GetClientIndexesResponse|bool
     */
    public function GetClientIndexes(\StructType\GetClientIndexes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientIndexes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientContactLogs
     * Meta informations extracted from the WSDL
     * - documentation: Get contact logs for a client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientContactLogs $parameters
     * @return \StructType\GetClientContactLogsResponse|bool
     */
    public function GetClientContactLogs(\StructType\GetClientContactLogs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientContactLogs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContactLogTypes
     * Meta informations extracted from the WSDL
     * - documentation: Get contact log types for a client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContactLogTypes $parameters
     * @return \StructType\GetContactLogTypesResponse|bool
     */
    public function GetContactLogTypes(\StructType\GetContactLogTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContactLogTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientFormulaNotes
     * Meta informations extracted from the WSDL
     * - documentation: Gets a list of client formula notes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientFormulaNotes $parameters
     * @return \StructType\GetClientFormulaNotesResponse|bool
     */
    public function GetClientFormulaNotes(\StructType\GetClientFormulaNotes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientFormulaNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientReferralTypes
     * Meta informations extracted from the WSDL
     * - documentation: Gets a list of clients.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientReferralTypes $parameters
     * @return \StructType\GetClientReferralTypesResponse|bool
     */
    public function GetClientReferralTypes(\StructType\GetClientReferralTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientReferralTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActiveClientMemberships
     * Meta informations extracted from the WSDL
     * - documentation: Gets the active membership for a given client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetActiveClientMemberships $parameters
     * @return \StructType\GetActiveClientMembershipsResponse|bool
     */
    public function GetActiveClientMemberships(\StructType\GetActiveClientMemberships $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetActiveClientMemberships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientContracts
     * Meta informations extracted from the WSDL
     * - documentation: Gets a list of contracts for a given client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientContracts $parameters
     * @return \StructType\GetClientContractsResponse|bool
     */
    public function GetClientContracts(\StructType\GetClientContracts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientContracts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientAccountBalances
     * Meta informations extracted from the WSDL
     * - documentation: Gets account balances for the given clients.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientAccountBalances $parameters
     * @return \StructType\GetClientAccountBalancesResponse|bool
     */
    public function GetClientAccountBalances(\StructType\GetClientAccountBalances $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientAccountBalances($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientServices
     * Meta informations extracted from the WSDL
     * - documentation: Gets a client service for a given client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientServices $parameters
     * @return \StructType\GetClientServicesResponse|bool
     */
    public function GetClientServices(\StructType\GetClientServices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientVisits
     * Meta informations extracted from the WSDL
     * - documentation: Get visits for a client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientVisits $parameters
     * @return \StructType\GetClientVisitsResponse|bool
     */
    public function GetClientVisits(\StructType\GetClientVisits $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientVisits($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientPurchases
     * Meta informations extracted from the WSDL
     * - documentation: Get purchases for a client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientPurchases $parameters
     * @return \StructType\GetClientPurchasesResponse|bool
     */
    public function GetClientPurchases(\StructType\GetClientPurchases $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientPurchases($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetClientSchedule
     * Meta informations extracted from the WSDL
     * - documentation: Get visits for a client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetClientSchedule $parameters
     * @return \StructType\GetClientScheduleResponse|bool
     */
    public function GetClientSchedule(\StructType\GetClientSchedule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetClientSchedule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRequiredClientFields
     * Meta informations extracted from the WSDL
     * - documentation: Updates a client service for a given client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRequiredClientFields $parameters
     * @return \StructType\GetRequiredClientFieldsResponse|bool
     */
    public function GetRequiredClientFields(\StructType\GetRequiredClientFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRequiredClientFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetActiveClientMembershipsResponse|\StructType\GetClientAccountBalancesResponse|\StructType\GetClientContactLogsResponse|\StructType\GetClientContractsResponse|\StructType\GetClientFormulaNotesResponse|\StructType\GetClientIndexesResponse|\StructType\GetClientPurchasesResponse|\StructType\GetClientReferralTypesResponse|\StructType\GetClientScheduleResponse|\StructType\GetClientServicesResponse|\StructType\GetClientsResponse|\StructType\GetClientVisitsResponse|\StructType\GetContactLogTypesResponse|\StructType\GetCrossRegionalClientAssociationsResponse|\StructType\GetCustomClientFieldsResponse|\StructType\GetRequiredClientFieldsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
