<?php

namespace EnumType;

/**
 * This class stands for ScheduleType EnumType
 * @subpackage Enumerations
 */
class ScheduleType
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'DropIn'
     * @return string 'DropIn'
     */
    const VALUE_DROP_IN = 'DropIn';
    /**
     * Constant for value 'Enrollment'
     * @return string 'Enrollment'
     */
    const VALUE_ENROLLMENT = 'Enrollment';
    /**
     * Constant for value 'Appointment'
     * @return string 'Appointment'
     */
    const VALUE_APPOINTMENT = 'Appointment';
    /**
     * Constant for value 'Resource'
     * @return string 'Resource'
     */
    const VALUE_RESOURCE = 'Resource';
    /**
     * Constant for value 'Media'
     * @return string 'Media'
     */
    const VALUE_MEDIA = 'Media';
    /**
     * Constant for value 'Arrival'
     * @return string 'Arrival'
     */
    const VALUE_ARRIVAL = 'Arrival';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_DROP_IN
     * @uses self::VALUE_ENROLLMENT
     * @uses self::VALUE_APPOINTMENT
     * @uses self::VALUE_RESOURCE
     * @uses self::VALUE_MEDIA
     * @uses self::VALUE_ARRIVAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_DROP_IN,
            self::VALUE_ENROLLMENT,
            self::VALUE_APPOINTMENT,
            self::VALUE_RESOURCE,
            self::VALUE_MEDIA,
            self::VALUE_ARRIVAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
