<?php

namespace EnumType;

/**
 * This class stands for AppointmentStatus EnumType
 * @subpackage Enumerations
 */
class AppointmentStatus
{
    /**
     * Constant for value 'Booked'
     * @return string 'Booked'
     */
    const VALUE_BOOKED = 'Booked';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Constant for value 'Arrived'
     * @return string 'Arrived'
     */
    const VALUE_ARRIVED = 'Arrived';
    /**
     * Constant for value 'NoShow'
     * @return string 'NoShow'
     */
    const VALUE_NO_SHOW = 'NoShow';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'LateCancelled'
     * @return string 'LateCancelled'
     */
    const VALUE_LATE_CANCELLED = 'LateCancelled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOOKED
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_ARRIVED
     * @uses self::VALUE_NO_SHOW
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_LATE_CANCELLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOOKED,
            self::VALUE_COMPLETED,
            self::VALUE_CONFIRMED,
            self::VALUE_ARRIVED,
            self::VALUE_NO_SHOW,
            self::VALUE_CANCELLED,
            self::VALUE_LATE_CANCELLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
