<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRep ArrayType
 * @subpackage Arrays
 */
class ArrayOfRep extends AbstractStructArrayBase
{
    /**
     * The Rep
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rep[]
     */
    public $Rep;
    /**
     * Constructor method for ArrayOfRep
     * @uses ArrayOfRep::setRep()
     * @param \StructType\Rep[] $rep
     */
    public function __construct(array $rep = array())
    {
        $this
            ->setRep($rep);
    }
    /**
     * Get Rep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rep[]|null
     */
    public function getRep()
    {
        return isset($this->Rep) ? $this->Rep : null;
    }
    /**
     * Set Rep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Rep[] $rep
     * @return \ArrayType\ArrayOfRep
     */
    public function setRep(array $rep = array())
    {
        foreach ($rep as $arrayOfRepRepItem) {
            // validation for constraint: itemType
            if (!$arrayOfRepRepItem instanceof \StructType\Rep) {
                throw new \InvalidArgumentException(sprintf('The Rep property can only contain items of \StructType\Rep, "%s" given', is_object($arrayOfRepRepItem) ? get_class($arrayOfRepRepItem) : gettype($arrayOfRepRepItem)), __LINE__);
            }
        }
        if (is_null($rep) || (is_array($rep) && empty($rep))) {
            unset($this->Rep);
        } else {
            $this->Rep = $rep;
        }
        return $this;
    }
    /**
     * Add item to Rep value
     * @throws \InvalidArgumentException
     * @param \StructType\Rep $item
     * @return \ArrayType\ArrayOfRep
     */
    public function addToRep(\StructType\Rep $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rep) {
            throw new \InvalidArgumentException(sprintf('The Rep property can only contain items of \StructType\Rep, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Rep[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Rep|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Rep|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Rep|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Rep|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Rep|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Rep
     */
    public function getAttributeName()
    {
        return 'Rep';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRep
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
