<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactLogSubtype ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactLogSubtype extends AbstractStructArrayBase
{
    /**
     * The ContactLogSubtype
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactLogSubtype[]
     */
    public $ContactLogSubtype;
    /**
     * Constructor method for ArrayOfContactLogSubtype
     * @uses ArrayOfContactLogSubtype::setContactLogSubtype()
     * @param \StructType\ContactLogSubtype[] $contactLogSubtype
     */
    public function __construct(array $contactLogSubtype = array())
    {
        $this
            ->setContactLogSubtype($contactLogSubtype);
    }
    /**
     * Get ContactLogSubtype value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactLogSubtype[]|null
     */
    public function getContactLogSubtype()
    {
        return isset($this->ContactLogSubtype) ? $this->ContactLogSubtype : null;
    }
    /**
     * Set ContactLogSubtype value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLogSubtype[] $contactLogSubtype
     * @return \ArrayType\ArrayOfContactLogSubtype
     */
    public function setContactLogSubtype(array $contactLogSubtype = array())
    {
        foreach ($contactLogSubtype as $arrayOfContactLogSubtypeContactLogSubtypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactLogSubtypeContactLogSubtypeItem instanceof \StructType\ContactLogSubtype) {
                throw new \InvalidArgumentException(sprintf('The ContactLogSubtype property can only contain items of \StructType\ContactLogSubtype, "%s" given', is_object($arrayOfContactLogSubtypeContactLogSubtypeItem) ? get_class($arrayOfContactLogSubtypeContactLogSubtypeItem) : gettype($arrayOfContactLogSubtypeContactLogSubtypeItem)), __LINE__);
            }
        }
        if (is_null($contactLogSubtype) || (is_array($contactLogSubtype) && empty($contactLogSubtype))) {
            unset($this->ContactLogSubtype);
        } else {
            $this->ContactLogSubtype = $contactLogSubtype;
        }
        return $this;
    }
    /**
     * Add item to ContactLogSubtype value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactLogSubtype $item
     * @return \ArrayType\ArrayOfContactLogSubtype
     */
    public function addToContactLogSubtype(\StructType\ContactLogSubtype $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactLogSubtype) {
            throw new \InvalidArgumentException(sprintf('The ContactLogSubtype property can only contain items of \StructType\ContactLogSubtype, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactLogSubtype[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactLogSubtype|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactLogSubtype|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactLogSubtype|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactLogSubtype|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactLogSubtype|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactLogSubtype
     */
    public function getAttributeName()
    {
        return 'ContactLogSubtype';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactLogSubtype
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
