<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientService ArrayType
 * @subpackage Arrays
 */
class ArrayOfClientService extends AbstractStructArrayBase
{
    /**
     * The ClientService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClientService[]
     */
    public $ClientService;
    /**
     * Constructor method for ArrayOfClientService
     * @uses ArrayOfClientService::setClientService()
     * @param \StructType\ClientService[] $clientService
     */
    public function __construct(array $clientService = array())
    {
        $this
            ->setClientService($clientService);
    }
    /**
     * Get ClientService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClientService[]|null
     */
    public function getClientService()
    {
        return isset($this->ClientService) ? $this->ClientService : null;
    }
    /**
     * Set ClientService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClientService[] $clientService
     * @return \ArrayType\ArrayOfClientService
     */
    public function setClientService(array $clientService = array())
    {
        foreach ($clientService as $arrayOfClientServiceClientServiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientServiceClientServiceItem instanceof \StructType\ClientService) {
                throw new \InvalidArgumentException(sprintf('The ClientService property can only contain items of \StructType\ClientService, "%s" given', is_object($arrayOfClientServiceClientServiceItem) ? get_class($arrayOfClientServiceClientServiceItem) : gettype($arrayOfClientServiceClientServiceItem)), __LINE__);
            }
        }
        if (is_null($clientService) || (is_array($clientService) && empty($clientService))) {
            unset($this->ClientService);
        } else {
            $this->ClientService = $clientService;
        }
        return $this;
    }
    /**
     * Add item to ClientService value
     * @throws \InvalidArgumentException
     * @param \StructType\ClientService $item
     * @return \ArrayType\ArrayOfClientService
     */
    public function addToClientService(\StructType\ClientService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClientService) {
            throw new \InvalidArgumentException(sprintf('The ClientService property can only contain items of \StructType\ClientService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientService[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClientService|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClientService|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClientService|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClientService|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClientService|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientService
     */
    public function getAttributeName()
    {
        return 'ClientService';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClientService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
