<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadClientPhotoResult StructType
 * @subpackage Structs
 */
class UploadClientPhotoResult extends MBResult
{
    /**
     * The PhotoUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhotoUrl;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * Constructor method for UploadClientPhotoResult
     * @uses UploadClientPhotoResult::setPhotoUrl()
     * @uses UploadClientPhotoResult::setClientID()
     * @param string $photoUrl
     * @param string $clientID
     */
    public function __construct($photoUrl = null, $clientID = null)
    {
        $this
            ->setPhotoUrl($photoUrl)
            ->setClientID($clientID);
    }
    /**
     * Get PhotoUrl value
     * @return string|null
     */
    public function getPhotoUrl()
    {
        return $this->PhotoUrl;
    }
    /**
     * Set PhotoUrl value
     * @param string $photoUrl
     * @return \StructType\UploadClientPhotoResult
     */
    public function setPhotoUrl($photoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($photoUrl) && !is_string($photoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($photoUrl)), __LINE__);
        }
        $this->PhotoUrl = $photoUrl;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\UploadClientPhotoResult
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadClientPhotoResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
