<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadClientPhotoRequest StructType
 * @subpackage Structs
 */
class UploadClientPhotoRequest extends MBRequest
{
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The Bytes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bytes;
    /**
     * Constructor method for UploadClientPhotoRequest
     * @uses UploadClientPhotoRequest::setClientID()
     * @uses UploadClientPhotoRequest::setBytes()
     * @param string $clientID
     * @param string $bytes
     */
    public function __construct($clientID = null, $bytes = null)
    {
        $this
            ->setClientID($clientID)
            ->setBytes($bytes);
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\UploadClientPhotoRequest
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get Bytes value
     * @return string|null
     */
    public function getBytes()
    {
        return $this->Bytes;
    }
    /**
     * Set Bytes value
     * @param string $bytes
     * @return \StructType\UploadClientPhotoRequest
     */
    public function setBytes($bytes = null)
    {
        // validation for constraint: string
        if (!is_null($bytes) && !is_string($bytes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bytes)), __LINE__);
        }
        $this->Bytes = $bytes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadClientPhotoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
