<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpcomingAutopayEvent StructType
 * @subpackage Structs
 */
class UpcomingAutopayEvent extends AbstractStructBase
{
    /**
     * The ScheduleDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ScheduleDate;
    /**
     * The ChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ChargeAmount;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentMethod;
    /**
     * Constructor method for UpcomingAutopayEvent
     * @uses UpcomingAutopayEvent::setScheduleDate()
     * @uses UpcomingAutopayEvent::setChargeAmount()
     * @uses UpcomingAutopayEvent::setPaymentMethod()
     * @param string $scheduleDate
     * @param float $chargeAmount
     * @param string $paymentMethod
     */
    public function __construct($scheduleDate = null, $chargeAmount = null, $paymentMethod = null)
    {
        $this
            ->setScheduleDate($scheduleDate)
            ->setChargeAmount($chargeAmount)
            ->setPaymentMethod($paymentMethod);
    }
    /**
     * Get ScheduleDate value
     * @return string
     */
    public function getScheduleDate()
    {
        return $this->ScheduleDate;
    }
    /**
     * Set ScheduleDate value
     * @param string $scheduleDate
     * @return \StructType\UpcomingAutopayEvent
     */
    public function setScheduleDate($scheduleDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleDate) && !is_string($scheduleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduleDate)), __LINE__);
        }
        $this->ScheduleDate = $scheduleDate;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \StructType\UpcomingAutopayEvent
     */
    public function setChargeAmount($chargeAmount = null)
    {
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @uses \EnumType\EPaymentMethod::valueIsValid()
     * @uses \EnumType\EPaymentMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \StructType\UpcomingAutopayEvent
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EPaymentMethod::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentMethod, implode(', ', \EnumType\EPaymentMethod::getValidValues())), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpcomingAutopayEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
