<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesRep StructType
 * @subpackage Structs
 */
class SalesRep extends MBObject
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The SalesRepNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalesRepNumber;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The SalesRepNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $SalesRepNumbers;
    /**
     * Constructor method for SalesRep
     * @uses SalesRep::setID()
     * @uses SalesRep::setSalesRepNumber()
     * @uses SalesRep::setFirstName()
     * @uses SalesRep::setLastName()
     * @uses SalesRep::setSalesRepNumbers()
     * @param int $iD
     * @param int $salesRepNumber
     * @param string $firstName
     * @param string $lastName
     * @param \ArrayType\ArrayOfInt $salesRepNumbers
     */
    public function __construct($iD = null, $salesRepNumber = null, $firstName = null, $lastName = null, \ArrayType\ArrayOfInt $salesRepNumbers = null)
    {
        $this
            ->setID($iD)
            ->setSalesRepNumber($salesRepNumber)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSalesRepNumbers($salesRepNumbers);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\SalesRep
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SalesRepNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalesRepNumber()
    {
        return isset($this->SalesRepNumber) ? $this->SalesRepNumber : null;
    }
    /**
     * Set SalesRepNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salesRepNumber
     * @return \StructType\SalesRep
     */
    public function setSalesRepNumber($salesRepNumber = null)
    {
        // validation for constraint: int
        if (!is_null($salesRepNumber) && !is_numeric($salesRepNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesRepNumber)), __LINE__);
        }
        if (is_null($salesRepNumber) || (is_array($salesRepNumber) && empty($salesRepNumber))) {
            unset($this->SalesRepNumber);
        } else {
            $this->SalesRepNumber = $salesRepNumber;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\SalesRep
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\SalesRep
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get SalesRepNumbers value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getSalesRepNumbers()
    {
        return $this->SalesRepNumbers;
    }
    /**
     * Set SalesRepNumbers value
     * @param \ArrayType\ArrayOfInt $salesRepNumbers
     * @return \StructType\SalesRep
     */
    public function setSalesRepNumbers(\ArrayType\ArrayOfInt $salesRepNumbers = null)
    {
        $this->SalesRepNumbers = $salesRepNumbers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesRep
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
