<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sale StructType
 * @subpackage Structs
 */
class Sale extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The SaleTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SaleTime;
    /**
     * The SaleDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SaleDate;
    /**
     * The SaleDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SaleDateTime;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The PurchasedItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPurchasedItem
     */
    public $PurchasedItems;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $Location;
    /**
     * The Payments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPayment
     */
    public $Payments;
    /**
     * Constructor method for Sale
     * @uses Sale::setID()
     * @uses Sale::setSaleTime()
     * @uses Sale::setSaleDate()
     * @uses Sale::setSaleDateTime()
     * @uses Sale::setClientID()
     * @uses Sale::setPurchasedItems()
     * @uses Sale::setLocation()
     * @uses Sale::setPayments()
     * @param int $iD
     * @param string $saleTime
     * @param string $saleDate
     * @param string $saleDateTime
     * @param string $clientID
     * @param \ArrayType\ArrayOfPurchasedItem $purchasedItems
     * @param \StructType\Location $location
     * @param \ArrayType\ArrayOfPayment $payments
     */
    public function __construct($iD = null, $saleTime = null, $saleDate = null, $saleDateTime = null, $clientID = null, \ArrayType\ArrayOfPurchasedItem $purchasedItems = null, \StructType\Location $location = null, \ArrayType\ArrayOfPayment $payments = null)
    {
        $this
            ->setID($iD)
            ->setSaleTime($saleTime)
            ->setSaleDate($saleDate)
            ->setSaleDateTime($saleDateTime)
            ->setClientID($clientID)
            ->setPurchasedItems($purchasedItems)
            ->setLocation($location)
            ->setPayments($payments);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Sale
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get SaleTime value
     * @return string
     */
    public function getSaleTime()
    {
        return $this->SaleTime;
    }
    /**
     * Set SaleTime value
     * @param string $saleTime
     * @return \StructType\Sale
     */
    public function setSaleTime($saleTime = null)
    {
        // validation for constraint: string
        if (!is_null($saleTime) && !is_string($saleTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleTime)), __LINE__);
        }
        $this->SaleTime = $saleTime;
        return $this;
    }
    /**
     * Get SaleDate value
     * @return string
     */
    public function getSaleDate()
    {
        return $this->SaleDate;
    }
    /**
     * Set SaleDate value
     * @param string $saleDate
     * @return \StructType\Sale
     */
    public function setSaleDate($saleDate = null)
    {
        // validation for constraint: string
        if (!is_null($saleDate) && !is_string($saleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleDate)), __LINE__);
        }
        $this->SaleDate = $saleDate;
        return $this;
    }
    /**
     * Get SaleDateTime value
     * @return string
     */
    public function getSaleDateTime()
    {
        return $this->SaleDateTime;
    }
    /**
     * Set SaleDateTime value
     * @param string $saleDateTime
     * @return \StructType\Sale
     */
    public function setSaleDateTime($saleDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($saleDateTime) && !is_string($saleDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleDateTime)), __LINE__);
        }
        $this->SaleDateTime = $saleDateTime;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\Sale
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get PurchasedItems value
     * @return \ArrayType\ArrayOfPurchasedItem|null
     */
    public function getPurchasedItems()
    {
        return $this->PurchasedItems;
    }
    /**
     * Set PurchasedItems value
     * @param \ArrayType\ArrayOfPurchasedItem $purchasedItems
     * @return \StructType\Sale
     */
    public function setPurchasedItems(\ArrayType\ArrayOfPurchasedItem $purchasedItems = null)
    {
        $this->PurchasedItems = $purchasedItems;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Location $location
     * @return \StructType\Sale
     */
    public function setLocation(\StructType\Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Payments value
     * @return \ArrayType\ArrayOfPayment|null
     */
    public function getPayments()
    {
        return $this->Payments;
    }
    /**
     * Set Payments value
     * @param \ArrayType\ArrayOfPayment $payments
     * @return \StructType\Sale
     */
    public function setPayments(\ArrayType\ArrayOfPayment $payments = null)
    {
        $this->Payments = $payments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sale
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
