<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Program StructType
 * @subpackage Structs
 */
class Program extends MBObject
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The ScheduleType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ScheduleType;
    /**
     * The CancelOffset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CancelOffset;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Program
     * @uses Program::setID()
     * @uses Program::setScheduleType()
     * @uses Program::setCancelOffset()
     * @uses Program::setName()
     * @param int $iD
     * @param string $scheduleType
     * @param int $cancelOffset
     * @param string $name
     */
    public function __construct($iD = null, $scheduleType = null, $cancelOffset = null, $name = null)
    {
        $this
            ->setID($iD)
            ->setScheduleType($scheduleType)
            ->setCancelOffset($cancelOffset)
            ->setName($name);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Program
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ScheduleType value
     * @return string
     */
    public function getScheduleType()
    {
        return $this->ScheduleType;
    }
    /**
     * Set ScheduleType value
     * @uses \EnumType\ScheduleType::valueIsValid()
     * @uses \EnumType\ScheduleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleType
     * @return \StructType\Program
     */
    public function setScheduleType($scheduleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ScheduleType::valueIsValid($scheduleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduleType, implode(', ', \EnumType\ScheduleType::getValidValues())), __LINE__);
        }
        $this->ScheduleType = $scheduleType;
        return $this;
    }
    /**
     * Get CancelOffset value
     * @return int
     */
    public function getCancelOffset()
    {
        return $this->CancelOffset;
    }
    /**
     * Set CancelOffset value
     * @param int $cancelOffset
     * @return \StructType\Program
     */
    public function setCancelOffset($cancelOffset = null)
    {
        // validation for constraint: int
        if (!is_null($cancelOffset) && !is_numeric($cancelOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cancelOffset)), __LINE__);
        }
        $this->CancelOffset = $cancelOffset;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Program
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Program
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
