<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MBResult StructType
 * @subpackage Structs
 */
class MBResult extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The XMLDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $XMLDetail;
    /**
     * The ResultCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultCount;
    /**
     * The CurrentPageIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentPageIndex;
    /**
     * The TotalPageCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalPageCount;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for MBResult
     * @uses MBResult::setStatus()
     * @uses MBResult::setErrorCode()
     * @uses MBResult::setXMLDetail()
     * @uses MBResult::setResultCount()
     * @uses MBResult::setCurrentPageIndex()
     * @uses MBResult::setTotalPageCount()
     * @uses MBResult::setMessage()
     * @param string $status
     * @param int $errorCode
     * @param string $xMLDetail
     * @param int $resultCount
     * @param int $currentPageIndex
     * @param int $totalPageCount
     * @param string $message
     */
    public function __construct($status = null, $errorCode = null, $xMLDetail = null, $resultCount = null, $currentPageIndex = null, $totalPageCount = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setErrorCode($errorCode)
            ->setXMLDetail($xMLDetail)
            ->setResultCount($resultCount)
            ->setCurrentPageIndex($currentPageIndex)
            ->setTotalPageCount($totalPageCount)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\StatusCode::valueIsValid()
     * @uses \EnumType\StatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\MBResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusCode::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\StatusCode::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\MBResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get XMLDetail value
     * @return string
     */
    public function getXMLDetail()
    {
        return $this->XMLDetail;
    }
    /**
     * Set XMLDetail value
     * @uses \EnumType\XMLDetailLevel::valueIsValid()
     * @uses \EnumType\XMLDetailLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $xMLDetail
     * @return \StructType\MBResult
     */
    public function setXMLDetail($xMLDetail = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMLDetailLevel::valueIsValid($xMLDetail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $xMLDetail, implode(', ', \EnumType\XMLDetailLevel::getValidValues())), __LINE__);
        }
        $this->XMLDetail = $xMLDetail;
        return $this;
    }
    /**
     * Get ResultCount value
     * @return int
     */
    public function getResultCount()
    {
        return $this->ResultCount;
    }
    /**
     * Set ResultCount value
     * @param int $resultCount
     * @return \StructType\MBResult
     */
    public function setResultCount($resultCount = null)
    {
        // validation for constraint: int
        if (!is_null($resultCount) && !is_numeric($resultCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCount)), __LINE__);
        }
        $this->ResultCount = $resultCount;
        return $this;
    }
    /**
     * Get CurrentPageIndex value
     * @return int
     */
    public function getCurrentPageIndex()
    {
        return $this->CurrentPageIndex;
    }
    /**
     * Set CurrentPageIndex value
     * @param int $currentPageIndex
     * @return \StructType\MBResult
     */
    public function setCurrentPageIndex($currentPageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($currentPageIndex) && !is_numeric($currentPageIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentPageIndex)), __LINE__);
        }
        $this->CurrentPageIndex = $currentPageIndex;
        return $this;
    }
    /**
     * Get TotalPageCount value
     * @return int
     */
    public function getTotalPageCount()
    {
        return $this->TotalPageCount;
    }
    /**
     * Set TotalPageCount value
     * @param int $totalPageCount
     * @return \StructType\MBResult
     */
    public function setTotalPageCount($totalPageCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalPageCount) && !is_numeric($totalPageCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalPageCount)), __LINE__);
        }
        $this->TotalPageCount = $totalPageCount;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\MBResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MBResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
