<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MBObject StructType
 * @subpackage Structs
 */
class MBObject extends AbstractStructBase
{
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Site
     */
    public $Site;
    /**
     * The Messages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Messages;
    /**
     * The Execute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Execute;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCode;
    /**
     * Constructor method for MBObject
     * @uses MBObject::setSite()
     * @uses MBObject::setMessages()
     * @uses MBObject::setExecute()
     * @uses MBObject::setErrorCode()
     * @param \StructType\Site $site
     * @param \ArrayType\ArrayOfString $messages
     * @param string $execute
     * @param string $errorCode
     */
    public function __construct(\StructType\Site $site = null, \ArrayType\ArrayOfString $messages = null, $execute = null, $errorCode = null)
    {
        $this
            ->setSite($site)
            ->setMessages($messages)
            ->setExecute($execute)
            ->setErrorCode($errorCode);
    }
    /**
     * Get Site value
     * @return \StructType\Site|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\Site $site
     * @return \StructType\MBObject
     */
    public function setSite(\StructType\Site $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Messages value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \ArrayType\ArrayOfString $messages
     * @return \StructType\MBObject
     */
    public function setMessages(\ArrayType\ArrayOfString $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
    /**
     * Get Execute value
     * @return string|null
     */
    public function getExecute()
    {
        return $this->Execute;
    }
    /**
     * Set Execute value
     * @param string $execute
     * @return \StructType\MBObject
     */
    public function setExecute($execute = null)
    {
        // validation for constraint: string
        if (!is_null($execute) && !is_string($execute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($execute)), __LINE__);
        }
        $this->Execute = $execute;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\MBObject
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MBObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
