<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * @subpackage Structs
 */
class Location extends MBObject
{
    /**
     * The BusinessID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BusinessID;
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SiteID;
    /**
     * The BusinessDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessDescription;
    /**
     * The AdditionalImageURLs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AdditionalImageURLs;
    /**
     * The FacilitySquareFeet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FacilitySquareFeet;
    /**
     * The TreatmentRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TreatmentRooms;
    /**
     * The ProSpaFinderSite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ProSpaFinderSite;
    /**
     * The HasClasses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $HasClasses;
    /**
     * The PhoneExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneExtension;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Tax1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Tax1;
    /**
     * The Tax2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Tax2;
    /**
     * The Tax3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Tax3;
    /**
     * The Tax4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Tax4;
    /**
     * The Tax5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Tax5;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateProvCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateProvCode;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The DistanceInMiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DistanceInMiles;
    /**
     * The ImageURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageURL;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The HasSite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasSite;
    /**
     * The CanBook
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanBook;
    /**
     * Constructor method for Location
     * @uses Location::setBusinessID()
     * @uses Location::setSiteID()
     * @uses Location::setBusinessDescription()
     * @uses Location::setAdditionalImageURLs()
     * @uses Location::setFacilitySquareFeet()
     * @uses Location::setTreatmentRooms()
     * @uses Location::setProSpaFinderSite()
     * @uses Location::setHasClasses()
     * @uses Location::setPhoneExtension()
     * @uses Location::setAction()
     * @uses Location::setID()
     * @uses Location::setName()
     * @uses Location::setAddress()
     * @uses Location::setAddress2()
     * @uses Location::setTax1()
     * @uses Location::setTax2()
     * @uses Location::setTax3()
     * @uses Location::setTax4()
     * @uses Location::setTax5()
     * @uses Location::setPhone()
     * @uses Location::setCity()
     * @uses Location::setStateProvCode()
     * @uses Location::setPostalCode()
     * @uses Location::setLatitude()
     * @uses Location::setLongitude()
     * @uses Location::setDistanceInMiles()
     * @uses Location::setImageURL()
     * @uses Location::setDescription()
     * @uses Location::setHasSite()
     * @uses Location::setCanBook()
     * @param int $businessID
     * @param int $siteID
     * @param string $businessDescription
     * @param \ArrayType\ArrayOfString $additionalImageURLs
     * @param int $facilitySquareFeet
     * @param int $treatmentRooms
     * @param bool $proSpaFinderSite
     * @param bool $hasClasses
     * @param string $phoneExtension
     * @param string $action
     * @param int $iD
     * @param string $name
     * @param string $address
     * @param string $address2
     * @param float $tax1
     * @param float $tax2
     * @param float $tax3
     * @param float $tax4
     * @param float $tax5
     * @param string $phone
     * @param string $city
     * @param string $stateProvCode
     * @param string $postalCode
     * @param float $latitude
     * @param float $longitude
     * @param float $distanceInMiles
     * @param string $imageURL
     * @param string $description
     * @param bool $hasSite
     * @param bool $canBook
     */
    public function __construct($businessID = null, $siteID = null, $businessDescription = null, \ArrayType\ArrayOfString $additionalImageURLs = null, $facilitySquareFeet = null, $treatmentRooms = null, $proSpaFinderSite = null, $hasClasses = null, $phoneExtension = null, $action = null, $iD = null, $name = null, $address = null, $address2 = null, $tax1 = null, $tax2 = null, $tax3 = null, $tax4 = null, $tax5 = null, $phone = null, $city = null, $stateProvCode = null, $postalCode = null, $latitude = null, $longitude = null, $distanceInMiles = null, $imageURL = null, $description = null, $hasSite = null, $canBook = null)
    {
        $this
            ->setBusinessID($businessID)
            ->setSiteID($siteID)
            ->setBusinessDescription($businessDescription)
            ->setAdditionalImageURLs($additionalImageURLs)
            ->setFacilitySquareFeet($facilitySquareFeet)
            ->setTreatmentRooms($treatmentRooms)
            ->setProSpaFinderSite($proSpaFinderSite)
            ->setHasClasses($hasClasses)
            ->setPhoneExtension($phoneExtension)
            ->setAction($action)
            ->setID($iD)
            ->setName($name)
            ->setAddress($address)
            ->setAddress2($address2)
            ->setTax1($tax1)
            ->setTax2($tax2)
            ->setTax3($tax3)
            ->setTax4($tax4)
            ->setTax5($tax5)
            ->setPhone($phone)
            ->setCity($city)
            ->setStateProvCode($stateProvCode)
            ->setPostalCode($postalCode)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setDistanceInMiles($distanceInMiles)
            ->setImageURL($imageURL)
            ->setDescription($description)
            ->setHasSite($hasSite)
            ->setCanBook($canBook);
    }
    /**
     * Get BusinessID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBusinessID()
    {
        return isset($this->BusinessID) ? $this->BusinessID : null;
    }
    /**
     * Set BusinessID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $businessID
     * @return \StructType\Location
     */
    public function setBusinessID($businessID = null)
    {
        // validation for constraint: int
        if (!is_null($businessID) && !is_numeric($businessID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($businessID)), __LINE__);
        }
        if (is_null($businessID) || (is_array($businessID) && empty($businessID))) {
            unset($this->BusinessID);
        } else {
            $this->BusinessID = $businessID;
        }
        return $this;
    }
    /**
     * Get SiteID value
     * @return int|null
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param int $siteID
     * @return \StructType\Location
     */
    public function setSiteID($siteID = null)
    {
        // validation for constraint: int
        if (!is_null($siteID) && !is_numeric($siteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($siteID)), __LINE__);
        }
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get BusinessDescription value
     * @return string|null
     */
    public function getBusinessDescription()
    {
        return $this->BusinessDescription;
    }
    /**
     * Set BusinessDescription value
     * @param string $businessDescription
     * @return \StructType\Location
     */
    public function setBusinessDescription($businessDescription = null)
    {
        // validation for constraint: string
        if (!is_null($businessDescription) && !is_string($businessDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessDescription)), __LINE__);
        }
        $this->BusinessDescription = $businessDescription;
        return $this;
    }
    /**
     * Get AdditionalImageURLs value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAdditionalImageURLs()
    {
        return $this->AdditionalImageURLs;
    }
    /**
     * Set AdditionalImageURLs value
     * @param \ArrayType\ArrayOfString $additionalImageURLs
     * @return \StructType\Location
     */
    public function setAdditionalImageURLs(\ArrayType\ArrayOfString $additionalImageURLs = null)
    {
        $this->AdditionalImageURLs = $additionalImageURLs;
        return $this;
    }
    /**
     * Get FacilitySquareFeet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFacilitySquareFeet()
    {
        return isset($this->FacilitySquareFeet) ? $this->FacilitySquareFeet : null;
    }
    /**
     * Set FacilitySquareFeet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $facilitySquareFeet
     * @return \StructType\Location
     */
    public function setFacilitySquareFeet($facilitySquareFeet = null)
    {
        // validation for constraint: int
        if (!is_null($facilitySquareFeet) && !is_numeric($facilitySquareFeet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($facilitySquareFeet)), __LINE__);
        }
        if (is_null($facilitySquareFeet) || (is_array($facilitySquareFeet) && empty($facilitySquareFeet))) {
            unset($this->FacilitySquareFeet);
        } else {
            $this->FacilitySquareFeet = $facilitySquareFeet;
        }
        return $this;
    }
    /**
     * Get TreatmentRooms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTreatmentRooms()
    {
        return isset($this->TreatmentRooms) ? $this->TreatmentRooms : null;
    }
    /**
     * Set TreatmentRooms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $treatmentRooms
     * @return \StructType\Location
     */
    public function setTreatmentRooms($treatmentRooms = null)
    {
        // validation for constraint: int
        if (!is_null($treatmentRooms) && !is_numeric($treatmentRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($treatmentRooms)), __LINE__);
        }
        if (is_null($treatmentRooms) || (is_array($treatmentRooms) && empty($treatmentRooms))) {
            unset($this->TreatmentRooms);
        } else {
            $this->TreatmentRooms = $treatmentRooms;
        }
        return $this;
    }
    /**
     * Get ProSpaFinderSite value
     * @return bool|null
     */
    public function getProSpaFinderSite()
    {
        return $this->ProSpaFinderSite;
    }
    /**
     * Set ProSpaFinderSite value
     * @param bool $proSpaFinderSite
     * @return \StructType\Location
     */
    public function setProSpaFinderSite($proSpaFinderSite = null)
    {
        // validation for constraint: boolean
        if (!is_null($proSpaFinderSite) && !is_bool($proSpaFinderSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($proSpaFinderSite)), __LINE__);
        }
        $this->ProSpaFinderSite = $proSpaFinderSite;
        return $this;
    }
    /**
     * Get HasClasses value
     * @return bool|null
     */
    public function getHasClasses()
    {
        return $this->HasClasses;
    }
    /**
     * Set HasClasses value
     * @param bool $hasClasses
     * @return \StructType\Location
     */
    public function setHasClasses($hasClasses = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasClasses) && !is_bool($hasClasses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasClasses)), __LINE__);
        }
        $this->HasClasses = $hasClasses;
        return $this;
    }
    /**
     * Get PhoneExtension value
     * @return string|null
     */
    public function getPhoneExtension()
    {
        return $this->PhoneExtension;
    }
    /**
     * Set PhoneExtension value
     * @param string $phoneExtension
     * @return \StructType\Location
     */
    public function setPhoneExtension($phoneExtension = null)
    {
        // validation for constraint: string
        if (!is_null($phoneExtension) && !is_string($phoneExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneExtension)), __LINE__);
        }
        $this->PhoneExtension = $phoneExtension;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\ActionCode::valueIsValid()
     * @uses \EnumType\ActionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\Location
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionCode::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\ActionCode::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iD
     * @return \StructType\Location
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Location
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\Location
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\Location
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Tax1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTax1()
    {
        return isset($this->Tax1) ? $this->Tax1 : null;
    }
    /**
     * Set Tax1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tax1
     * @return \StructType\Location
     */
    public function setTax1($tax1 = null)
    {
        if (is_null($tax1) || (is_array($tax1) && empty($tax1))) {
            unset($this->Tax1);
        } else {
            $this->Tax1 = $tax1;
        }
        return $this;
    }
    /**
     * Get Tax2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTax2()
    {
        return isset($this->Tax2) ? $this->Tax2 : null;
    }
    /**
     * Set Tax2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tax2
     * @return \StructType\Location
     */
    public function setTax2($tax2 = null)
    {
        if (is_null($tax2) || (is_array($tax2) && empty($tax2))) {
            unset($this->Tax2);
        } else {
            $this->Tax2 = $tax2;
        }
        return $this;
    }
    /**
     * Get Tax3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTax3()
    {
        return isset($this->Tax3) ? $this->Tax3 : null;
    }
    /**
     * Set Tax3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tax3
     * @return \StructType\Location
     */
    public function setTax3($tax3 = null)
    {
        if (is_null($tax3) || (is_array($tax3) && empty($tax3))) {
            unset($this->Tax3);
        } else {
            $this->Tax3 = $tax3;
        }
        return $this;
    }
    /**
     * Get Tax4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTax4()
    {
        return isset($this->Tax4) ? $this->Tax4 : null;
    }
    /**
     * Set Tax4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tax4
     * @return \StructType\Location
     */
    public function setTax4($tax4 = null)
    {
        if (is_null($tax4) || (is_array($tax4) && empty($tax4))) {
            unset($this->Tax4);
        } else {
            $this->Tax4 = $tax4;
        }
        return $this;
    }
    /**
     * Get Tax5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTax5()
    {
        return isset($this->Tax5) ? $this->Tax5 : null;
    }
    /**
     * Set Tax5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tax5
     * @return \StructType\Location
     */
    public function setTax5($tax5 = null)
    {
        if (is_null($tax5) || (is_array($tax5) && empty($tax5))) {
            unset($this->Tax5);
        } else {
            $this->Tax5 = $tax5;
        }
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\Location
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Location
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateProvCode value
     * @return string|null
     */
    public function getStateProvCode()
    {
        return $this->StateProvCode;
    }
    /**
     * Set StateProvCode value
     * @param string $stateProvCode
     * @return \StructType\Location
     */
    public function setStateProvCode($stateProvCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvCode) && !is_string($stateProvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateProvCode)), __LINE__);
        }
        $this->StateProvCode = $stateProvCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Location
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLatitude()
    {
        return isset($this->Latitude) ? $this->Latitude : null;
    }
    /**
     * Set Latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $latitude
     * @return \StructType\Location
     */
    public function setLatitude($latitude = null)
    {
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->Latitude);
        } else {
            $this->Latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get Longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongitude()
    {
        return isset($this->Longitude) ? $this->Longitude : null;
    }
    /**
     * Set Longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longitude
     * @return \StructType\Location
     */
    public function setLongitude($longitude = null)
    {
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->Longitude);
        } else {
            $this->Longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get DistanceInMiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDistanceInMiles()
    {
        return isset($this->DistanceInMiles) ? $this->DistanceInMiles : null;
    }
    /**
     * Set DistanceInMiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $distanceInMiles
     * @return \StructType\Location
     */
    public function setDistanceInMiles($distanceInMiles = null)
    {
        if (is_null($distanceInMiles) || (is_array($distanceInMiles) && empty($distanceInMiles))) {
            unset($this->DistanceInMiles);
        } else {
            $this->DistanceInMiles = $distanceInMiles;
        }
        return $this;
    }
    /**
     * Get ImageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->ImageURL;
    }
    /**
     * Set ImageURL value
     * @param string $imageURL
     * @return \StructType\Location
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        $this->ImageURL = $imageURL;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Location
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get HasSite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasSite()
    {
        return isset($this->HasSite) ? $this->HasSite : null;
    }
    /**
     * Set HasSite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasSite
     * @return \StructType\Location
     */
    public function setHasSite($hasSite = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSite) && !is_bool($hasSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasSite)), __LINE__);
        }
        if (is_null($hasSite) || (is_array($hasSite) && empty($hasSite))) {
            unset($this->HasSite);
        } else {
            $this->HasSite = $hasSite;
        }
        return $this;
    }
    /**
     * Get CanBook value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanBook()
    {
        return isset($this->CanBook) ? $this->CanBook : null;
    }
    /**
     * Set CanBook value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canBook
     * @return \StructType\Location
     */
    public function setCanBook($canBook = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBook) && !is_bool($canBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canBook)), __LINE__);
        }
        if (is_null($canBook) || (is_array($canBook) && empty($canBook))) {
            unset($this->CanBook);
        } else {
            $this->CanBook = $canBook;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
