<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Liability StructType
 * @subpackage Structs
 */
class Liability extends AbstractStructBase
{
    /**
     * The IsReleased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReleased;
    /**
     * The AgreementDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AgreementDate;
    /**
     * The ReleasedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReleasedBy;
    /**
     * Constructor method for Liability
     * @uses Liability::setIsReleased()
     * @uses Liability::setAgreementDate()
     * @uses Liability::setReleasedBy()
     * @param bool $isReleased
     * @param string $agreementDate
     * @param int $releasedBy
     */
    public function __construct($isReleased = null, $agreementDate = null, $releasedBy = null)
    {
        $this
            ->setIsReleased($isReleased)
            ->setAgreementDate($agreementDate)
            ->setReleasedBy($releasedBy);
    }
    /**
     * Get IsReleased value
     * @return bool
     */
    public function getIsReleased()
    {
        return $this->IsReleased;
    }
    /**
     * Set IsReleased value
     * @param bool $isReleased
     * @return \StructType\Liability
     */
    public function setIsReleased($isReleased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReleased) && !is_bool($isReleased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isReleased)), __LINE__);
        }
        $this->IsReleased = $isReleased;
        return $this;
    }
    /**
     * Get AgreementDate value
     * @return string
     */
    public function getAgreementDate()
    {
        return $this->AgreementDate;
    }
    /**
     * Set AgreementDate value
     * @param string $agreementDate
     * @return \StructType\Liability
     */
    public function setAgreementDate($agreementDate = null)
    {
        // validation for constraint: string
        if (!is_null($agreementDate) && !is_string($agreementDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agreementDate)), __LINE__);
        }
        $this->AgreementDate = $agreementDate;
        return $this;
    }
    /**
     * Get ReleasedBy value
     * @return int
     */
    public function getReleasedBy()
    {
        return $this->ReleasedBy;
    }
    /**
     * Set ReleasedBy value
     * @param int $releasedBy
     * @return \StructType\Liability
     */
    public function setReleasedBy($releasedBy = null)
    {
        // validation for constraint: int
        if (!is_null($releasedBy) && !is_numeric($releasedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($releasedBy)), __LINE__);
        }
        $this->ReleasedBy = $releasedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Liability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
