<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientAccountBalancesRequest StructType
 * @subpackage Structs
 */
class GetClientAccountBalancesRequest extends MBRequest
{
    /**
     * The BalanceDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BalanceDate;
    /**
     * The ClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ClassID;
    /**
     * The ClientIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ClientIDs;
    /**
     * Constructor method for GetClientAccountBalancesRequest
     * @uses GetClientAccountBalancesRequest::setBalanceDate()
     * @uses GetClientAccountBalancesRequest::setClassID()
     * @uses GetClientAccountBalancesRequest::setClientIDs()
     * @param string $balanceDate
     * @param int $classID
     * @param \ArrayType\ArrayOfString $clientIDs
     */
    public function __construct($balanceDate = null, $classID = null, \ArrayType\ArrayOfString $clientIDs = null)
    {
        $this
            ->setBalanceDate($balanceDate)
            ->setClassID($classID)
            ->setClientIDs($clientIDs);
    }
    /**
     * Get BalanceDate value
     * @return string
     */
    public function getBalanceDate()
    {
        return $this->BalanceDate;
    }
    /**
     * Set BalanceDate value
     * @param string $balanceDate
     * @return \StructType\GetClientAccountBalancesRequest
     */
    public function setBalanceDate($balanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($balanceDate) && !is_string($balanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceDate)), __LINE__);
        }
        $this->BalanceDate = $balanceDate;
        return $this;
    }
    /**
     * Get ClassID value
     * @return int
     */
    public function getClassID()
    {
        return $this->ClassID;
    }
    /**
     * Set ClassID value
     * @param int $classID
     * @return \StructType\GetClientAccountBalancesRequest
     */
    public function setClassID($classID = null)
    {
        // validation for constraint: int
        if (!is_null($classID) && !is_numeric($classID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($classID)), __LINE__);
        }
        $this->ClassID = $classID;
        return $this;
    }
    /**
     * Get ClientIDs value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getClientIDs()
    {
        return $this->ClientIDs;
    }
    /**
     * Set ClientIDs value
     * @param \ArrayType\ArrayOfString $clientIDs
     * @return \StructType\GetClientAccountBalancesRequest
     */
    public function setClientIDs(\ArrayType\ArrayOfString $clientIDs = null)
    {
        $this->ClientIDs = $clientIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetClientAccountBalancesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
